/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.rsocket.metadata.WellKnownAuthType;
import io.rsocket.util.CharByteBufUtil;

public class AuthMetadataCodec {
    static final int STREAM_METADATA_KNOWN_MASK = 128;
    static final byte STREAM_METADATA_LENGTH_MASK = 127;
    static final int USERNAME_BYTES_LENGTH = 2;
    static final int AUTH_TYPE_ID_LENGTH = 1;
    static final char[] EMPTY_CHARS_ARRAY = new char[0];

    private AuthMetadataCodec() {
    }

    public static ByteBuf encodeMetadata(ByteBufAllocator allocator, String customAuthType, ByteBuf metadata) {
        int actualASCIILength = ByteBufUtil.utf8Bytes((CharSequence)customAuthType);
        if (actualASCIILength != customAuthType.length()) {
            throw new IllegalArgumentException("custom auth type must be US_ASCII characters only");
        }
        if (actualASCIILength < 1 || actualASCIILength > 128) {
            throw new IllegalArgumentException("custom auth type must have a strictly positive length that fits on 7 unsigned bits, ie 1-128");
        }
        int capacity = 1 + actualASCIILength;
        ByteBuf headerBuffer = allocator.buffer(capacity, capacity);
        headerBuffer.writeByte(actualASCIILength - 1);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)headerBuffer, (CharSequence)customAuthType, (int)actualASCIILength);
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{headerBuffer, metadata});
    }

    public static ByteBuf encodeMetadata(ByteBufAllocator allocator, WellKnownAuthType authType, ByteBuf metadata) {
        if (authType == WellKnownAuthType.UNPARSEABLE_AUTH_TYPE || authType == WellKnownAuthType.UNKNOWN_RESERVED_AUTH_TYPE) {
            throw new IllegalArgumentException("only allowed AuthType should be used");
        }
        int capacity = 1;
        ByteBuf headerBuffer = allocator.buffer(capacity, capacity).writeByte(authType.getIdentifier() | 0x80);
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{headerBuffer, metadata});
    }

    public static ByteBuf encodeSimpleMetadata(ByteBufAllocator allocator, char[] username, char[] password) {
        int usernameLength = CharByteBufUtil.utf8Bytes(username);
        if (usernameLength > 65535) {
            throw new IllegalArgumentException("Username should be shorter than or equal to 65535 bytes length in UTF-8 encoding");
        }
        int passwordLength = CharByteBufUtil.utf8Bytes(password);
        int capacity = 3 + usernameLength + passwordLength;
        ByteBuf buffer = allocator.buffer(capacity, capacity).writeByte(WellKnownAuthType.SIMPLE.getIdentifier() | 0x80).writeShort(usernameLength);
        CharByteBufUtil.writeUtf8(buffer, username);
        CharByteBufUtil.writeUtf8(buffer, password);
        return buffer;
    }

    public static ByteBuf encodeBearerMetadata(ByteBufAllocator allocator, char[] token) {
        int tokenLength = CharByteBufUtil.utf8Bytes(token);
        int capacity = 1 + tokenLength;
        ByteBuf buffer = allocator.buffer(capacity, capacity).writeByte(WellKnownAuthType.BEARER.getIdentifier() | 0x80);
        CharByteBufUtil.writeUtf8(buffer, token);
        return buffer;
    }

    public static ByteBuf encodeMetadataWithCompression(ByteBufAllocator allocator, String authType, ByteBuf metadata) {
        WellKnownAuthType wkn = WellKnownAuthType.fromString(authType);
        if (wkn == WellKnownAuthType.UNPARSEABLE_AUTH_TYPE) {
            return AuthMetadataCodec.encodeMetadata(allocator, authType, metadata);
        }
        return AuthMetadataCodec.encodeMetadata(allocator, wkn, metadata);
    }

    public static boolean isWellKnownAuthType(ByteBuf metadata) {
        byte lengthOrId = metadata.getByte(0);
        return (lengthOrId & 0x7F) != lengthOrId;
    }

    public static WellKnownAuthType readWellKnownAuthType(ByteBuf metadata) {
        if (metadata.readableBytes() < 1) {
            throw new IllegalStateException("Unable to decode Well Know Auth type. Not enough readable bytes");
        }
        byte lengthOrId = metadata.readByte();
        byte normalizedId = (byte)(lengthOrId & 0x7F);
        if (normalizedId != lengthOrId) {
            return WellKnownAuthType.fromIdentifier(normalizedId);
        }
        return WellKnownAuthType.UNPARSEABLE_AUTH_TYPE;
    }

    public static CharSequence readCustomAuthType(ByteBuf metadata) {
        if (metadata.readableBytes() < 2) {
            throw new IllegalStateException("Unable to decode custom Auth type. Not enough readable bytes");
        }
        byte encodedLength = metadata.readByte();
        if (encodedLength < 0) {
            throw new IllegalStateException("Unable to decode custom Auth type. Incorrect auth type length");
        }
        int realLength = encodedLength + 1;
        if (metadata.readableBytes() < realLength) {
            throw new IllegalArgumentException("Unable to decode custom Auth type. Malformed length or auth type string");
        }
        return metadata.readCharSequence(realLength, CharsetUtil.US_ASCII);
    }

    public static ByteBuf readPayload(ByteBuf metadata) {
        if (metadata.readableBytes() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return metadata.readSlice(metadata.readableBytes());
    }

    public static ByteBuf readUsername(ByteBuf simpleAuthMetadata) {
        int usernameLength = AuthMetadataCodec.readUsernameLength(simpleAuthMetadata);
        if (usernameLength == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return simpleAuthMetadata.readSlice(usernameLength);
    }

    public static ByteBuf readPassword(ByteBuf simpleAuthMetadata) {
        if (simpleAuthMetadata.readableBytes() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return simpleAuthMetadata.readSlice(simpleAuthMetadata.readableBytes());
    }

    public static char[] readUsernameAsCharArray(ByteBuf simpleAuthMetadata) {
        int usernameLength = AuthMetadataCodec.readUsernameLength(simpleAuthMetadata);
        if (usernameLength == 0) {
            return EMPTY_CHARS_ARRAY;
        }
        return CharByteBufUtil.readUtf8(simpleAuthMetadata, usernameLength);
    }

    public static char[] readPasswordAsCharArray(ByteBuf simpleAuthMetadata) {
        if (simpleAuthMetadata.readableBytes() == 0) {
            return EMPTY_CHARS_ARRAY;
        }
        return CharByteBufUtil.readUtf8(simpleAuthMetadata, simpleAuthMetadata.readableBytes());
    }

    public static char[] readBearerTokenAsCharArray(ByteBuf bearerAuthMetadata) {
        if (bearerAuthMetadata.readableBytes() == 0) {
            return EMPTY_CHARS_ARRAY;
        }
        return CharByteBufUtil.readUtf8(bearerAuthMetadata, bearerAuthMetadata.readableBytes());
    }

    private static int readUsernameLength(ByteBuf simpleAuthMetadata) {
        if (simpleAuthMetadata.readableBytes() < 2) {
            throw new IllegalStateException("Unable to decode custom username. Not enough readable bytes");
        }
        int usernameLength = simpleAuthMetadata.readUnsignedShort();
        if (simpleAuthMetadata.readableBytes() < usernameLength) {
            throw new IllegalArgumentException("Unable to decode username. Malformed username length or content");
        }
        return usernameLength;
    }
}

