/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import io.rsocket.plugins.CompositeRequestInterceptor;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.InterceptorRegistry;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.RequestInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.util.annotation.Nullable;

public class InitializingInterceptorRegistry
extends InterceptorRegistry {
    @Nullable
    public RequestInterceptor initRequesterRequestInterceptor(RSocket rSocketRequester) {
        return CompositeRequestInterceptor.create(this.getRequestInterceptorsForRequester().stream().map(factory -> (RequestInterceptor)factory.apply(rSocketRequester)).collect(Collectors.toList()));
    }

    @Nullable
    public RequestInterceptor initResponderRequestInterceptor(RSocket rSocketResponder, RequestInterceptor ... perConnectionInterceptors) {
        return CompositeRequestInterceptor.create(Stream.concat(Stream.of(perConnectionInterceptors), this.getRequestInterceptorsForResponder().stream().map(inteptorFactory -> (RequestInterceptor)inteptorFactory.apply(rSocketResponder))).collect(Collectors.toList()));
    }

    public DuplexConnection initConnection(DuplexConnectionInterceptor.Type type, DuplexConnection connection) {
        for (DuplexConnectionInterceptor interceptor : this.getConnectionInterceptors()) {
            connection = (DuplexConnection)interceptor.apply(type, connection);
        }
        return connection;
    }

    public RSocket initRequester(RSocket rsocket) {
        for (RSocketInterceptor interceptor : this.getRequesterInterceptors()) {
            rsocket = (RSocket)interceptor.apply(rsocket);
        }
        return rsocket;
    }

    public RSocket initResponder(RSocket rsocket) {
        for (RSocketInterceptor interceptor : this.getResponderInterceptors()) {
            rsocket = (RSocket)interceptor.apply(rsocket);
        }
        return rsocket;
    }

    public SocketAcceptor initSocketAcceptor(SocketAcceptor acceptor) {
        for (SocketAcceptorInterceptor interceptor : this.getSocketAcceptorInterceptors()) {
            acceptor = (SocketAcceptor)interceptor.apply(acceptor);
        }
        return acceptor;
    }
}

