/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.RSocketErrorException;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.InitializingInterceptorRegistry;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

class ClientServerInputMultiplexer
implements CoreSubscriber<ByteBuf>,
Closeable {
    private final InternalDuplexConnection serverReceiver;
    private final InternalDuplexConnection clientReceiver;
    private final DuplexConnection serverConnection;
    private final DuplexConnection clientConnection;
    private final DuplexConnection source;
    private final boolean isClient;
    private Subscription s;
    private Throwable t;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<ClientServerInputMultiplexer> STATE = AtomicIntegerFieldUpdater.newUpdater(ClientServerInputMultiplexer.class, "state");

    public ClientServerInputMultiplexer(DuplexConnection source, InitializingInterceptorRegistry registry, boolean isClient) {
        this.source = source;
        this.isClient = isClient;
        this.serverReceiver = new InternalDuplexConnection(this, source);
        this.clientReceiver = new InternalDuplexConnection(this, source);
        this.serverConnection = registry.initConnection(DuplexConnectionInterceptor.Type.SERVER, this.serverReceiver);
        this.clientConnection = registry.initConnection(DuplexConnectionInterceptor.Type.CLIENT, this.clientReceiver);
    }

    DuplexConnection asServerConnection() {
        return this.serverConnection;
    }

    DuplexConnection asClientConnection() {
        return this.clientConnection;
    }

    public void dispose() {
        this.source.dispose();
    }

    public boolean isDisposed() {
        return this.source.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.source.onClose();
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(ByteBuf frame) {
        DuplexConnectionInterceptor.Type type;
        int streamId = FrameHeaderCodec.streamId(frame);
        if (streamId == 0) {
            switch (FrameHeaderCodec.frameType(frame)) {
                case LEASE: 
                case KEEPALIVE: 
                case ERROR: {
                    type = this.isClient ? DuplexConnectionInterceptor.Type.CLIENT : DuplexConnectionInterceptor.Type.SERVER;
                    break;
                }
                default: {
                    type = this.isClient ? DuplexConnectionInterceptor.Type.SERVER : DuplexConnectionInterceptor.Type.CLIENT;
                    break;
                }
            }
        } else {
            type = (streamId & 1) == 0 ? DuplexConnectionInterceptor.Type.SERVER : DuplexConnectionInterceptor.Type.CLIENT;
        }
        switch (type) {
            case CLIENT: {
                this.clientReceiver.onNext(frame);
                break;
            }
            case SERVER: {
                this.serverReceiver.onNext(frame);
            }
        }
    }

    public void onComplete() {
        int previousState = STATE.getAndSet(this, Integer.MIN_VALUE);
        if (previousState == Integer.MIN_VALUE || previousState == 0) {
            return;
        }
        if (this.clientReceiver.isSubscribed()) {
            this.clientReceiver.onComplete();
        }
        if (this.serverReceiver.isSubscribed()) {
            this.serverReceiver.onComplete();
        }
    }

    public void onError(Throwable t) {
        this.t = t;
        int previousState = STATE.getAndSet(this, Integer.MIN_VALUE);
        if (previousState == Integer.MIN_VALUE || previousState == 0) {
            return;
        }
        if (this.clientReceiver.isSubscribed()) {
            this.clientReceiver.onError(t);
        }
        if (this.serverReceiver.isSubscribed()) {
            this.serverReceiver.onError(t);
        }
    }

    boolean notifyRequested() {
        int currentState = this.incrementAndGetCheckingState();
        if (currentState == Integer.MIN_VALUE) {
            return false;
        }
        if (currentState == 2) {
            this.source.receive().subscribe((CoreSubscriber)this);
        }
        return true;
    }

    int incrementAndGetCheckingState() {
        int next;
        int prev;
        do {
            if ((prev = this.state) != Integer.MIN_VALUE) continue;
            return prev;
        } while (!STATE.compareAndSet(this, prev, next = prev + 1));
        return next;
    }

    private static class InternalDuplexConnection
    extends Flux<ByteBuf>
    implements Subscription,
    DuplexConnection {
        private final ClientServerInputMultiplexer clientServerInputMultiplexer;
        private final DuplexConnection source;
        private volatile int state;
        static final AtomicIntegerFieldUpdater<InternalDuplexConnection> STATE = AtomicIntegerFieldUpdater.newUpdater(InternalDuplexConnection.class, "state");
        CoreSubscriber<? super ByteBuf> actual;

        public InternalDuplexConnection(ClientServerInputMultiplexer clientServerInputMultiplexer, DuplexConnection source) {
            this.clientServerInputMultiplexer = clientServerInputMultiplexer;
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
            if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
                this.actual = actual;
                actual.onSubscribe((Subscription)this);
            } else {
                Operators.error(actual, (Throwable)new IllegalStateException("InternalDuplexConnection allows only single subscription"));
            }
        }

        public void request(long n) {
            ClientServerInputMultiplexer multiplexer;
            if (this.state == 1 && STATE.compareAndSet(this, 1, 2) && !(multiplexer = this.clientServerInputMultiplexer).notifyRequested()) {
                Throwable t = multiplexer.t;
                if (t != null) {
                    this.actual.onError(t);
                } else {
                    this.actual.onComplete();
                }
            }
        }

        public void cancel() {
        }

        void onNext(ByteBuf frame) {
            this.actual.onNext((Object)frame);
        }

        void onComplete() {
            this.actual.onComplete();
        }

        void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void sendFrame(int streamId, ByteBuf frame) {
            this.source.sendFrame(streamId, frame);
        }

        @Override
        public void sendErrorAndClose(RSocketErrorException e) {
            this.source.sendErrorAndClose(e);
        }

        @Override
        public Flux<ByteBuf> receive() {
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.source.alloc();
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.source.remoteAddress();
        }

        public void dispose() {
            this.source.dispose();
        }

        public boolean isDisposed() {
            return this.source.isDisposed();
        }

        public boolean isSubscribed() {
            return this.state != 0;
        }

        @Override
        public Mono<Void> onClose() {
            return this.source.onClose();
        }

        @Override
        public double availability() {
            return this.source.availability();
        }
    }
}

