/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class Ewma {
    final long tau;
    volatile long stamp;
    static final AtomicLongFieldUpdater<Ewma> STAMP = AtomicLongFieldUpdater.newUpdater(Ewma.class, "stamp");
    volatile double ewma;

    public Ewma(long halfLife, TimeUnit unit, double initialValue) {
        this.tau = Clock.unit().convert((long)((double)halfLife / Math.log(2.0)), unit);
        this.ewma = initialValue;
        STAMP.lazySet(this, 0L);
    }

    public synchronized void insert(double x) {
        long now = Clock.now();
        double elapsed = Math.max(0L, now - this.stamp);
        STAMP.lazySet(this, now);
        double w = Math.exp(-elapsed / (double)this.tau);
        this.ewma = w * this.ewma + (1.0 - w) * x;
    }

    public synchronized void reset(double value) {
        this.stamp = 0L;
        this.ewma = value;
    }

    public double value() {
        return this.ewma;
    }

    public String toString() {
        return "Ewma(value=" + this.ewma + ", age=" + (Clock.now() - this.stamp) + ")";
    }
}

