/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.rsocket.RSocket;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.RequestInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class InterceptorRegistry {
    private List<Function<RSocket, ? extends RequestInterceptor>> requesterRequestInterceptors = new ArrayList<Function<RSocket, ? extends RequestInterceptor>>();
    private List<Function<RSocket, ? extends RequestInterceptor>> responderRequestInterceptors = new ArrayList<Function<RSocket, ? extends RequestInterceptor>>();
    private List<RSocketInterceptor> requesterRSocketInterceptors = new ArrayList<RSocketInterceptor>();
    private List<RSocketInterceptor> responderRSocketInterceptors = new ArrayList<RSocketInterceptor>();
    private List<SocketAcceptorInterceptor> socketAcceptorInterceptors = new ArrayList<SocketAcceptorInterceptor>();
    private List<DuplexConnectionInterceptor> connectionInterceptors = new ArrayList<DuplexConnectionInterceptor>();

    public InterceptorRegistry forRequestsInRequester(Function<RSocket, ? extends RequestInterceptor> interceptor) {
        this.requesterRequestInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forRequestsInResponder(Function<RSocket, ? extends RequestInterceptor> interceptor) {
        this.responderRequestInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forRequester(RSocketInterceptor interceptor) {
        this.requesterRSocketInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forRequester(Consumer<List<RSocketInterceptor>> consumer) {
        consumer.accept(this.requesterRSocketInterceptors);
        return this;
    }

    public InterceptorRegistry forResponder(RSocketInterceptor interceptor) {
        this.responderRSocketInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forResponder(Consumer<List<RSocketInterceptor>> consumer) {
        consumer.accept(this.responderRSocketInterceptors);
        return this;
    }

    public InterceptorRegistry forSocketAcceptor(SocketAcceptorInterceptor interceptor) {
        this.socketAcceptorInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forSocketAcceptor(Consumer<List<SocketAcceptorInterceptor>> consumer) {
        consumer.accept(this.socketAcceptorInterceptors);
        return this;
    }

    public InterceptorRegistry forConnection(DuplexConnectionInterceptor interceptor) {
        this.connectionInterceptors.add(interceptor);
        return this;
    }

    public InterceptorRegistry forConnection(Consumer<List<DuplexConnectionInterceptor>> consumer) {
        consumer.accept(this.connectionInterceptors);
        return this;
    }

    List<Function<RSocket, ? extends RequestInterceptor>> getRequestInterceptorsForRequester() {
        return this.requesterRequestInterceptors;
    }

    List<Function<RSocket, ? extends RequestInterceptor>> getRequestInterceptorsForResponder() {
        return this.responderRequestInterceptors;
    }

    List<RSocketInterceptor> getRequesterInterceptors() {
        return this.requesterRSocketInterceptors;
    }

    List<RSocketInterceptor> getResponderInterceptors() {
        return this.responderRSocketInterceptors;
    }

    List<DuplexConnectionInterceptor> getConnectionInterceptors() {
        return this.connectionInterceptors;
    }

    List<SocketAcceptorInterceptor> getSocketAcceptorInterceptors() {
        return this.socketAcceptorInterceptors;
    }
}

