/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.Ewma;
import io.rsocket.loadbalance.FrugalQuantile;
import io.rsocket.loadbalance.Median;
import io.rsocket.loadbalance.Quantile;
import io.rsocket.loadbalance.WeightedStats;
import io.rsocket.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class BaseWeightedStats
implements WeightedStats {
    private static final double DEFAULT_LOWER_QUANTILE = 0.5;
    private static final double DEFAULT_HIGHER_QUANTILE = 0.8;
    private static final int INACTIVITY_FACTOR = 500;
    private static final long DEFAULT_INITIAL_INTER_ARRIVAL_TIME = Clock.unit().convert(1L, TimeUnit.SECONDS);
    private static final double STARTUP_PENALTY = 2.251799813685247E15;
    private final Quantile lowerQuantile;
    private final Quantile higherQuantile;
    private final Ewma availabilityPercentage;
    private final Median median;
    private final Ewma interArrivalTime;
    private final long tau;
    private final long inactivityFactor;
    private long errorStamp;
    private long stamp;
    private long stamp0;
    private long duration;
    private volatile int pendingRequests;
    private static final AtomicIntegerFieldUpdater<BaseWeightedStats> PENDING_REQUESTS = AtomicIntegerFieldUpdater.newUpdater(BaseWeightedStats.class, "pendingRequests");
    private volatile int pendingStreams;
    private static final AtomicIntegerFieldUpdater<BaseWeightedStats> PENDING_STREAMS = AtomicIntegerFieldUpdater.newUpdater(BaseWeightedStats.class, "pendingStreams");

    protected BaseWeightedStats() {
        this(new FrugalQuantile(0.5), new FrugalQuantile(0.8), 500L);
    }

    private BaseWeightedStats(Quantile lowerQuantile, Quantile higherQuantile, long inactivityFactor) {
        long now;
        this.lowerQuantile = lowerQuantile;
        this.higherQuantile = higherQuantile;
        this.inactivityFactor = inactivityFactor;
        this.stamp = now = Clock.now();
        this.errorStamp = now;
        this.stamp0 = now;
        this.duration = 0L;
        this.pendingRequests = 0;
        this.median = new Median();
        this.interArrivalTime = new Ewma(1L, TimeUnit.MINUTES, DEFAULT_INITIAL_INTER_ARRIVAL_TIME);
        this.availabilityPercentage = new Ewma(5L, TimeUnit.SECONDS, 1.0);
        this.tau = Clock.unit().convert((long)(5.0 / Math.log(2.0)), TimeUnit.SECONDS);
    }

    @Override
    public double lowerQuantileLatency() {
        return this.lowerQuantile.estimation();
    }

    @Override
    public double higherQuantileLatency() {
        return this.higherQuantile.estimation();
    }

    @Override
    public int pending() {
        return this.pendingRequests + this.pendingStreams;
    }

    @Override
    public double weightedAvailability() {
        if (Clock.now() - this.stamp > this.tau) {
            this.updateAvailability(1.0);
        }
        return this.availabilityPercentage.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double predictedLatency() {
        double latency;
        long elapsed;
        long now = Clock.now();
        BaseWeightedStats baseWeightedStats = this;
        synchronized (baseWeightedStats) {
            elapsed = Math.max(now - this.stamp, 1L);
        }
        double prediction = this.median.estimation();
        int pending = this.pending();
        if (prediction == 0.0) {
            latency = pending == 0 ? 0.0 : 2.251799813685247E15 + (double)pending;
        } else if (pending == 0 && (double)elapsed > (double)this.inactivityFactor * this.interArrivalTime.value()) {
            this.median.insert(0.0);
            latency = this.median.estimation();
        } else {
            double predicted = prediction * (double)pending;
            double instant = this.instantaneous(now, pending);
            latency = predicted < instant ? instant / (double)pending : prediction;
        }
        return latency;
    }

    long instantaneous(long now, int pending) {
        return this.duration + (now - this.stamp0) * (long)pending;
    }

    void startStream() {
        PENDING_STREAMS.incrementAndGet(this);
    }

    void stopStream() {
        PENDING_STREAMS.decrementAndGet(this);
    }

    synchronized long startRequest() {
        long now = Clock.now();
        int pendingRequests = this.pendingRequests;
        this.interArrivalTime.insert(now - this.stamp);
        this.duration += Math.max(0L, now - this.stamp0) * (long)pendingRequests;
        PENDING_REQUESTS.lazySet(this, pendingRequests + 1);
        this.stamp = now;
        this.stamp0 = now;
        return now;
    }

    synchronized long stopRequest(long timestamp) {
        long now = Clock.now();
        int pendingRequests = this.pendingRequests;
        this.duration += Math.max(0L, now - this.stamp0) * (long)pendingRequests - (now - timestamp);
        PENDING_REQUESTS.lazySet(this, pendingRequests - 1);
        this.stamp0 = now;
        return now;
    }

    synchronized void record(double roundTripTime) {
        this.median.insert(roundTripTime);
        this.lowerQuantile.insert(roundTripTime);
        this.higherQuantile.insert(roundTripTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailability(double value) {
        this.availabilityPercentage.insert(value);
        if (value == 0.0) {
            BaseWeightedStats baseWeightedStats = this;
            synchronized (baseWeightedStats) {
                this.errorStamp = Clock.now();
            }
        }
    }

    public String toString() {
        return "Stats{lowerQuantile=" + this.lowerQuantile.estimation() + ", higherQuantile=" + this.higherQuantile.estimation() + ", inactivityFactor=" + this.inactivityFactor + ", tau=" + this.tau + ", errorPercentage=" + this.availabilityPercentage.value() + ", pending=" + this.pendingRequests + ", errorStamp=" + this.errorStamp + ", stamp=" + this.stamp + ", stamp0=" + this.stamp0 + ", duration=" + this.duration + ", median=" + this.median.estimation() + ", interArrivalTime=" + this.interArrivalTime.value() + ", pendingStreams=" + this.pendingStreams + ", availability=" + this.availabilityPercentage.value() + '}';
    }
}

