/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.uri.UriHandler;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import reactor.netty.tcp.TcpServer;

public final class TcpUriHandler
implements UriHandler {
    private static final String SCHEME = "tcp";

    public Optional<ClientTransport> buildClient(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (!SCHEME.equals(uri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(TcpClientTransport.create(uri.getHost(), uri.getPort()));
    }

    public Optional<ServerTransport> buildServer(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (!SCHEME.equals(uri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(TcpServerTransport.create(TcpServer.create().host(uri.getHost()).port(uri.getPort())));
    }
}

