/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerResponse;

public final class WebsocketServerTransport
implements ServerTransport<CloseableChannel>,
TransportHeaderAware {
    private final HttpServer server;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketServerTransport(HttpServer server) {
        this.server = server;
    }

    public static WebsocketServerTransport create(int port) {
        HttpServer httpServer = HttpServer.create().port(port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        HttpServer httpServer = HttpServer.create().host(bindAddress).port(port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        return WebsocketServerTransport.create(address.getHostName(), address.getPort());
    }

    public static WebsocketServerTransport create(HttpServer server) {
        Objects.requireNonNull(server, "server must not be null");
        return new WebsocketServerTransport(server);
    }

    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = Objects.requireNonNull(transportHeaders, "transportHeaders must not be null");
    }

    public Mono<CloseableChannel> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.handle((request, response) -> {
            this.transportHeaders.get().forEach((arg_0, arg_1) -> ((HttpServerResponse)response).addHeader(arg_0, arg_1));
            return response.sendWebsocket(WebsocketRouteTransport.newHandler(acceptor));
        }).bind().map(CloseableChannel::new);
    }
}

