/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.aliases;

import com.google.common.collect.ImmutableMap;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import io.searchbox.indices.aliases.AliasMapping;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ModifyAliases
extends GenericResultAbstractAction {
    protected ModifyAliases(Builder builder) {
        super(builder);
        LinkedList<Map<String, Object>> actions = new LinkedList<Map<String, Object>>();
        for (AliasMapping aliasMapping : builder.actions) {
            actions.addAll(aliasMapping.getData());
        }
        this.payload = ImmutableMap.of((Object)"actions", actions);
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        return super.buildURI(elasticsearchVersion) + "/_aliases";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static class Builder
    extends AbstractAction.Builder<ModifyAliases, Builder> {
        private List<AliasMapping> actions = new LinkedList<AliasMapping>();

        public Builder(AliasMapping action) {
            this.actions.add(action);
        }

        public Builder(Collection<AliasMapping> actions) {
            this.actions.addAll(actions);
        }

        public Builder addAlias(AliasMapping action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAlias(Collection<AliasMapping> actions) {
            this.actions.addAll(actions);
            return this;
        }

        @Override
        public ModifyAliases build() {
            return new ModifyAliases(this);
        }
    }
}

