/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.streamingaead.StreamingAeadKeyTemplates;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.TransactionManagerImpl;
import org.sirix.api.Database;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.api.Transaction;
import org.sirix.api.TransactionManager;
import org.sirix.cache.BufferManager;
import org.sirix.exception.SirixIOException;
import org.sirix.io.bytepipe.Encryptor;
import org.sirix.utils.SirixFiles;

public abstract class AbstractLocalDatabase<T extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>>
implements Database<T> {
    private final AtomicLong mResourceID = new AtomicLong();
    protected final TransactionManager mTransactionManager;
    protected boolean mClosed;
    protected final ConcurrentMap<Path, BufferManager> mBufferManagers;
    protected final BiMap<Long, String> mResources;
    protected final DatabaseConfiguration mDBConfig;

    public AbstractLocalDatabase(DatabaseConfiguration dbConfig) {
        this.mDBConfig = (DatabaseConfiguration)Preconditions.checkNotNull((Object)dbConfig);
        this.mResources = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        this.mBufferManagers = new ConcurrentHashMap<Path, BufferManager>();
        this.mTransactionManager = new TransactionManagerImpl();
    }

    @Override
    public synchronized boolean createResource(ResourceConfiguration resConfig) {
        this.assertNotClosed();
        boolean returnVal = true;
        resConfig.setDatabaseConfiguration(this.mDBConfig);
        Path path = this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(resConfig.resourcePath);
        if (Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            returnVal = false;
        }
        if (returnVal) {
            for (ResourceConfiguration.ResourcePaths resourcePath : ResourceConfiguration.ResourcePaths.values()) {
                Path toCreate = path.resolve(resourcePath.getPath());
                try {
                    if (resourcePath.isFolder()) {
                        Files.createDirectory(toCreate, new FileAttribute[0]);
                        if (resourcePath == ResourceConfiguration.ResourcePaths.ENCRYPTION_KEY) {
                            this.createAndStoreKeysetIfNeeded(resConfig, toCreate);
                        }
                    } else {
                        Files.createFile(toCreate, new FileAttribute[0]);
                    }
                }
                catch (IOException | SecurityException | UnsupportedOperationException e) {
                    returnVal = false;
                }
                if (!returnVal) break;
            }
        }
        if (returnVal) {
            this.mResourceID.set(this.mDBConfig.getMaxResourceID());
            ResourceConfiguration.serialize(resConfig.setID(this.mResourceID.getAndIncrement()));
            this.mDBConfig.setMaximumResourceID(this.mResourceID.get());
            this.mResources.forcePut((Object)this.mResourceID.get(), (Object)resConfig.getResource().getFileName().toString());
            returnVal = this.bootstrapResource(resConfig);
        }
        if (!returnVal) {
            SirixFiles.recursiveRemove(resConfig.resourcePath);
        }
        return returnVal;
    }

    void createAndStoreKeysetIfNeeded(ResourceConfiguration resConfig, Path createdPath) {
        Path encryptionKeyPath = createdPath.resolve("encryptionKey.json");
        if (resConfig.byteHandlePipeline.getComponents().contains(new Encryptor(createdPath.getParent()))) {
            try {
                Files.createFile(encryptionKeyPath, new FileAttribute[0]);
                KeysetHandle handle = KeysetHandle.generateNew((KeyTemplate)StreamingAeadKeyTemplates.AES256_CTR_HMAC_SHA256_4KB);
                CleartextKeysetHandle.write((KeysetHandle)handle, (KeysetWriter)JsonKeysetWriter.withPath((Path)encryptionKeyPath));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected abstract boolean bootstrapResource(ResourceConfiguration var1);

    @Override
    public synchronized Database<T> removeResource(String name) {
        this.assertNotClosed();
        Path resourceFile = this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(name);
        if (Databases.hasOpenResourceManagers(resourceFile)) {
            throw new IllegalStateException("Opened resource managers found, must be closed first.");
        }
        if (Files.exists(resourceFile, new LinkOption[0]) && ResourceConfiguration.ResourcePaths.compareStructure(resourceFile) == 0) {
            SirixFiles.recursiveRemove(resourceFile);
            this.mBufferManagers.remove(resourceFile);
        }
        return this;
    }

    @Override
    public synchronized String getResourceName(@Nonnegative long id) {
        this.assertNotClosed();
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"The ID must be >= 0!");
        return (String)this.mResources.get((Object)id);
    }

    @Override
    public synchronized long getResourceID(String name) {
        this.assertNotClosed();
        return (Long)this.mResources.inverse().get(Preconditions.checkNotNull((Object)name));
    }

    protected void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Database is already closed.");
        }
    }

    @Override
    public DatabaseConfiguration getDatabaseConfig() {
        this.assertNotClosed();
        return this.mDBConfig;
    }

    @Override
    public synchronized boolean existsResource(String resourceName) {
        this.assertNotClosed();
        Path resourceFile = this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(resourceName);
        return Files.exists(resourceFile, new LinkOption[0]) && ResourceConfiguration.ResourcePaths.compareStructure(resourceFile) == 0;
    }

    @Override
    public List<Path> listResources() {
        List<Path> list;
        block8: {
            this.assertNotClosed();
            Stream<Path> stream = Files.list(this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()));
            try {
                list = stream.collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SirixIOException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    BufferManager getPageCache(Path resourceFile) {
        return (BufferManager)this.mBufferManagers.get(resourceFile);
    }

    @Override
    public Transaction beginTransaction() {
        return null;
    }
}

