/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import org.sirix.access.Databases;
import org.sirix.access.ResourceStore;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.io.Reader;
import org.sirix.io.Storage;
import org.sirix.page.PageReference;
import org.sirix.page.UberPage;

public abstract class AbstractResourceStore<R extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>>
implements ResourceStore<R> {
    protected final ConcurrentMap<Path, R> mResourceManagers;

    public AbstractResourceStore(ConcurrentMap<Path, R> resourceManagers) {
        this.mResourceManagers = resourceManagers;
    }

    protected UberPage getUberPage(Storage storage) {
        UberPage uberPage;
        if (storage.exists()) {
            try (Reader reader = storage.createReader();){
                PageReference firstRef = reader.readUberPageReference();
                if (firstRef.getPage() == null) {
                    uberPage = (UberPage)reader.read(firstRef, null);
                }
                uberPage = (UberPage)firstRef.getPage();
            }
        } else {
            uberPage = new UberPage();
        }
        return uberPage;
    }

    @Override
    public boolean hasOpenResourceManager(Path resourceFile) {
        Preconditions.checkNotNull((Object)resourceFile);
        return this.mResourceManagers.containsKey(resourceFile);
    }

    @Override
    public R getOpenResourceManager(Path resourceFile) {
        Preconditions.checkNotNull((Object)resourceFile);
        return (R)((ResourceManager)this.mResourceManagers.get(resourceFile));
    }

    @Override
    public void close() {
        this.mResourceManagers.forEach((resourceName, resourceMgr) -> resourceMgr.close());
    }

    @Override
    public boolean closeResource(Path resourceFile) {
        ResourceManager manager = (ResourceManager)this.mResourceManagers.remove(resourceFile);
        Databases.removeResourceManager(resourceFile, manager);
        return manager != null;
    }
}

