/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.LocalJsonDatabase;
import org.sirix.access.LocalXmlDatabase;
import org.sirix.access.ResourceStore;
import org.sirix.access.json.JsonResourceStore;
import org.sirix.access.xml.XmlResourceStore;
import org.sirix.api.Database;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.interfaces.Node;
import org.sirix.node.json.JsonDocumentRootNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.settings.Fixed;

public enum DatabaseType {
    XML{

        @Override
        public <R extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>, S extends ResourceStore<R>> Database<R> createDatabase(DatabaseConfiguration dbConfig, S store) {
            return new LocalXmlDatabase(dbConfig, (XmlResourceStore)store);
        }

        @Override
        public Node getDocumentNode(SirixDeweyID id) {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, id);
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new XdmDocumentRootNode(nodeDel, structDel);
        }
    }
    ,
    JSON{

        @Override
        public <R extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>, S extends ResourceStore<R>> Database<R> createDatabase(DatabaseConfiguration dbConfig, S store) {
            return new LocalJsonDatabase(dbConfig, (JsonResourceStore)store);
        }

        @Override
        public Node getDocumentNode(SirixDeweyID id) {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, null);
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new JsonDocumentRootNode(nodeDel, structDel);
        }
    };

    private static final Map<String, DatabaseType> stringToEnum;

    public static Optional<DatabaseType> fromString(String symbol) {
        return Optional.ofNullable(stringToEnum.get(symbol));
    }

    public abstract <R extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>, S extends ResourceStore<R>> Database<R> createDatabase(DatabaseConfiguration var1, S var2);

    public abstract Node getDocumentNode(SirixDeweyID var1);

    static {
        stringToEnum = Stream.of(DatabaseType.values()).collect(Collectors.toMap(Object::toString, e -> e));
    }
}

