/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.DatabaseType;
import org.sirix.access.ResourceStore;
import org.sirix.access.json.JsonResourceStore;
import org.sirix.access.xml.XmlResourceStore;
import org.sirix.api.Database;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixUsageException;
import org.sirix.utils.SirixFiles;

public final class Databases {
    private static final ConcurrentMap<Path, Set<Database<?>>> DATABASE_SESSIONS = new ConcurrentHashMap();
    private static final ConcurrentMap<Path, Set<ResourceManager<?, ?>>> RESOURCE_MANAGERS = new ConcurrentHashMap();
    private static final ConcurrentMap<Path, Semaphore> RESOURCE_READ_SEMAPHORES = new ConcurrentHashMap<Path, Semaphore>();
    private static final ConcurrentMap<Path, Lock> RESOURCE_WRITE_SEMAPHORES = new ConcurrentHashMap<Path, Lock>();

    public static Semaphore computeReadSempahoreIfAbsent(Path resourcePath, int numberOfPermits) {
        return RESOURCE_READ_SEMAPHORES.computeIfAbsent(resourcePath, res -> new Semaphore(numberOfPermits));
    }

    public static Lock computeWriteLockIfAbsent(Path resourcePath) {
        return RESOURCE_WRITE_SEMAPHORES.computeIfAbsent(resourcePath, res -> new ReentrantLock());
    }

    public static synchronized boolean createXmlDatabase(DatabaseConfiguration dbConfig) throws SirixIOException {
        return Databases.createTheDatabase(dbConfig.setDatabaseType(DatabaseType.XML));
    }

    public static synchronized boolean createJsonDatabase(DatabaseConfiguration dbConfig) throws SirixIOException {
        return Databases.createTheDatabase(dbConfig.setDatabaseType(DatabaseType.JSON));
    }

    private static boolean createTheDatabase(DatabaseConfiguration dbConfig) {
        boolean returnVal = true;
        if (Files.exists(dbConfig.getFile(), new LinkOption[0])) {
            returnVal = false;
        } else {
            try {
                Files.createDirectories(dbConfig.getFile(), new FileAttribute[0]);
            }
            catch (IOException | SecurityException | UnsupportedOperationException e) {
                returnVal = false;
            }
            if (returnVal) {
                for (DatabaseConfiguration.DatabasePaths paths : DatabaseConfiguration.DatabasePaths.values()) {
                    Path toCreate = dbConfig.getFile().resolve(paths.getFile());
                    if (paths.isFolder()) {
                        try {
                            Files.createDirectory(toCreate, new FileAttribute[0]);
                        }
                        catch (IOException | SecurityException | UnsupportedOperationException e) {
                            returnVal = false;
                        }
                    } else {
                        try {
                            returnVal = toCreate.getFileName().equals(DatabaseConfiguration.DatabasePaths.LOCK.getFile().getFileName()) ? true : Files.createFile(toCreate, new FileAttribute[0]) != null;
                        }
                        catch (IOException e) {
                            SirixFiles.recursiveRemove(dbConfig.getFile());
                            throw new SirixIOException(e);
                        }
                    }
                    if (!returnVal) break;
                }
            }
            DatabaseConfiguration.serialize(dbConfig);
            if (!returnVal) {
                SirixFiles.recursiveRemove(dbConfig.getFile());
            }
        }
        return returnVal;
    }

    public static synchronized void removeDatabase(Path dbFile) throws SirixIOException {
        if (!DATABASE_SESSIONS.containsKey(dbFile) && Files.exists(dbFile, new LinkOption[0])) {
            SirixFiles.recursiveRemove(dbFile);
        }
    }

    public static synchronized Database<XmlResourceManager> openXmlDatabase(Path file) {
        return Databases.openDatabase(file, new XmlResourceStore(), DatabaseType.XML);
    }

    public static synchronized Database<JsonResourceManager> openJsonDatabase(Path file) {
        return Databases.openDatabase(file, new JsonResourceStore(), DatabaseType.JSON);
    }

    private static Database<?> openDatabase(Path file, ResourceStore<? extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>> store, DatabaseType databaseType) {
        Preconditions.checkNotNull((Object)file);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new SirixUsageException("DB could not be opened (since it was not created?) at location", file.toString());
        }
        DatabaseConfiguration dbConfig = DatabaseConfiguration.deserialize(file);
        if (dbConfig == null) {
            throw new IllegalStateException("Configuration may not be null!");
        }
        Database database = databaseType.createDatabase(dbConfig, store);
        Databases.putDatabase(file.toAbsolutePath(), database);
        return database;
    }

    public static synchronized boolean existsDatabase(Path dbPath) {
        return Files.exists(dbPath, new LinkOption[0]) && DatabaseConfiguration.DatabasePaths.compareStructure(dbPath) == 0;
    }

    static synchronized void putDatabase(Path file, Database<?> database) {
        Set databases = DATABASE_SESSIONS.getOrDefault(file, new HashSet());
        databases.add(database);
        DATABASE_SESSIONS.put(file, databases);
    }

    static synchronized void removeDatabase(Path file, Database<?> database) {
        Set databases = (Set)DATABASE_SESSIONS.get(file);
        databases.remove(database);
        if (databases.isEmpty()) {
            DATABASE_SESSIONS.remove(file);
        }
    }

    public static synchronized void putResourceManager(Path file, ResourceManager<?, ?> resourceManager) {
        RESOURCE_MANAGERS.computeIfAbsent(file, path -> new HashSet()).add(resourceManager);
    }

    public static synchronized void removeResourceManager(Path file, ResourceManager<?, ?> resourceManager) {
        Set resourceManagers = (Set)RESOURCE_MANAGERS.get(file);
        if (resourceManagers == null) {
            return;
        }
        resourceManagers.remove(resourceManager);
        if (resourceManagers.isEmpty()) {
            RESOURCE_MANAGERS.remove(file);
        }
    }

    public static synchronized boolean hasOpenResourceManagers(Path file) {
        Set resourceManagers = (Set)RESOURCE_MANAGERS.get(file);
        return resourceManagers != null && !resourceManagers.isEmpty();
    }
}

