/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.MoreObjects;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.sirix.access.AbstractLocalDatabase;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.xml.XmlResourceStore;
import org.sirix.api.Database;
import org.sirix.api.ResourceManager;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.cache.BufferManager;
import org.sirix.cache.BufferManagerImpl;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixUsageException;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.SirixFiles;
import org.slf4j.LoggerFactory;

public final class LocalXmlDatabase
extends AbstractLocalDatabase<XmlResourceManager> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(LocalXmlDatabase.class));
    private final XmlResourceStore mResourceStore;

    LocalXmlDatabase(DatabaseConfiguration dbConfig, XmlResourceStore store) {
        super(dbConfig);
        this.mResourceStore = store;
    }

    @Override
    public synchronized void close() throws SirixException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mResourceStore.close();
        this.mTransactionManager.close();
        Databases.removeDatabase(this.mDBConfig.getFile(), this);
        SirixFiles.recursiveRemove(this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.LOCK.getFile()));
    }

    @Override
    public synchronized XmlResourceManager openResourceManager(String resource) {
        this.assertNotClosed();
        Path resourceFile = this.mDBConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(resource);
        if (!Files.exists(resourceFile, new LinkOption[0])) {
            throw new SirixUsageException("Resource could not be opened (since it was not created?) at location", resourceFile.toString());
        }
        if (this.mResourceStore.hasOpenResourceManager(resourceFile)) {
            return (XmlResourceManager)this.mResourceStore.getOpenResourceManager(resourceFile);
        }
        ResourceConfiguration resourceConfig = ResourceConfiguration.deserialize(resourceFile);
        assert (resourceConfig.resourcePath.getParent().getParent().equals(this.mDBConfig.getFile()));
        this.mResources.forcePut((Object)resourceConfig.getID(), (Object)resourceConfig.getResource().getFileName().toString());
        if (!this.mBufferManagers.containsKey(resourceFile)) {
            this.mBufferManagers.put(resourceFile, new BufferManagerImpl());
        }
        ResourceManager resourceManager = this.mResourceStore.openResource((Database)this, resourceConfig, (BufferManager)this.mBufferManagers.get(resourceFile), resourceFile);
        return resourceManager;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dbConfig", (Object)this.mDBConfig).toString();
    }

    @Override
    protected boolean bootstrapResource(ResourceConfiguration resConfig) {
        boolean returnVal = true;
        try (XmlResourceManager resourceTrxManager = this.openResourceManager(resConfig.getResource().getFileName().toString());
             XmlNodeTrx wtx = (XmlNodeTrx)resourceTrxManager.beginNodeTrx();){
            wtx.commit();
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
            returnVal = false;
        }
        return returnVal;
    }
}

