/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnegative;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.trx.node.HashType;
import org.sirix.exception.SirixIOException;
import org.sirix.io.StorageType;
import org.sirix.io.bytepipe.ByteHandlePipeline;
import org.sirix.io.bytepipe.ByteHandler;
import org.sirix.io.bytepipe.ByteHandlerKind;
import org.sirix.io.bytepipe.SnappyCompressor;
import org.sirix.node.NodePersistenterImpl;
import org.sirix.node.interfaces.RecordPersister;
import org.sirix.settings.VersioningType;

public final class ResourceConfiguration {
    private static final StorageType STORAGE = StorageType.FILE;
    private static final VersioningType VERSIONING = VersioningType.SLIDING_SNAPSHOT;
    private static final HashType HASHKIND = HashType.ROLLING;
    private static final int VERSIONSTORESTORE = 3;
    private static final RecordPersister PERSISTENTER = new NodePersistenterImpl();
    public final StorageType storageType;
    public final VersioningType revisioningType;
    public final HashType hashType;
    public final int numberOfRevisionsToRestore;
    public final ByteHandlePipeline byteHandlePipeline;
    public Path resourcePath;
    private DatabaseConfiguration databaseConfig;
    public final boolean useTextCompression;
    public final boolean withPathSummary;
    public final RecordPersister recordPersister;
    private long id;
    public final boolean areDeweyIDsStored;
    private String resourceName;
    private static final String[] JSONNAMES = new String[]{"revisioning", "revisioningClass", "numbersOfRevisiontoRestore", "byteHandlerClasses", "storageKind", "hashKind", "compression", "pathSummary", "resourceID", "deweyIDsStored", "persistenter"};

    public static Builder newBuilder(String resource) {
        return new Builder(resource);
    }

    private ResourceConfiguration(Builder builder) {
        this.storageType = builder.mType;
        this.byteHandlePipeline = builder.mByteHandler;
        this.revisioningType = builder.mRevisionKind;
        this.hashType = builder.mHashKind;
        this.numberOfRevisionsToRestore = builder.mRevisionsToRestore;
        this.useTextCompression = builder.mCompression;
        this.withPathSummary = builder.mPathSummary;
        this.areDeweyIDsStored = builder.mUseDeweyIDs;
        this.recordPersister = builder.mPersistenter;
        this.resourceName = builder.mResource;
    }

    ResourceConfiguration setDatabaseConfiguration(DatabaseConfiguration config) {
        this.databaseConfig = (DatabaseConfiguration)Preconditions.checkNotNull((Object)config);
        this.resourcePath = this.databaseConfig.getFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(this.resourceName);
        return this;
    }

    public ResourceConfiguration setID(@Nonnegative long id) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"The ID must be >= 0!");
        this.id = id;
        return this;
    }

    public long getID() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storageType, this.revisioningType, this.hashType, this.resourcePath, this.databaseConfig});
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration)obj;
        return Objects.equals((Object)this.storageType, (Object)other.storageType) && Objects.equals((Object)this.revisioningType, (Object)other.revisioningType) && Objects.equals((Object)this.hashType, (Object)other.hashType) && Objects.equals(this.resourcePath, other.resourcePath) && Objects.equals(this.databaseConfig, other.databaseConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Resource", (Object)this.resourcePath).add("Type", (Object)this.storageType).add("Revision", (Object)this.revisioningType).add("HashKind", (Object)this.hashType).toString();
    }

    public Path getResource() {
        return this.resourcePath;
    }

    public Path getConfigFile() {
        return this.resourcePath.resolve(ResourcePaths.CONFIG_BINARY.getPath());
    }

    public static void serialize(ResourceConfiguration config) throws SirixIOException {
        Path configFile = config.getConfigFile();
        try (FileWriter fileWriter = new FileWriter(configFile.toFile());
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            jsonWriter.beginObject();
            jsonWriter.name(JSONNAMES[0]);
            jsonWriter.beginObject();
            jsonWriter.name(JSONNAMES[1]).value(config.revisioningType.name());
            jsonWriter.name(JSONNAMES[2]).value((long)config.numberOfRevisionsToRestore);
            jsonWriter.endObject();
            ByteHandlePipeline byteHandler = config.byteHandlePipeline;
            jsonWriter.name(JSONNAMES[3]);
            jsonWriter.beginArray();
            for (ByteHandler handler : byteHandler.getComponents()) {
                ByteHandlerKind.getKind(handler.getClass()).serialize(handler, jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.name(JSONNAMES[4]).value(config.storageType.name());
            jsonWriter.name(JSONNAMES[5]).value(config.hashType.name());
            jsonWriter.name(JSONNAMES[6]).value(config.useTextCompression);
            jsonWriter.name(JSONNAMES[7]).value(config.withPathSummary);
            jsonWriter.name(JSONNAMES[8]).value(config.id);
            jsonWriter.name(JSONNAMES[9]).value(config.areDeweyIDsStored);
            jsonWriter.name(JSONNAMES[10]).value(config.recordPersister.getClass().getName());
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        DatabaseConfiguration.serialize(config.databaseConfig);
    }

    public static ResourceConfiguration deserialize(Path file) throws SirixIOException {
        try {
            Path configFile = file.resolve(ResourcePaths.CONFIG_BINARY.getPath());
            FileReader fileReader = new FileReader(configFile.toFile());
            JsonReader jsonReader = new JsonReader((Reader)fileReader);
            jsonReader.beginObject();
            String name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[0]));
            jsonReader.beginObject();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[1]));
            VersioningType revisioning = VersioningType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[2]));
            int revisionToRestore = jsonReader.nextInt();
            jsonReader.endObject();
            ArrayList<ByteHandler> handlerList = new ArrayList<ByteHandler>();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[3]));
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginObject();
                Class<?> clazzName = Class.forName(jsonReader.nextName());
                handlerList.add(ByteHandlerKind.getKind(clazzName).deserialize(jsonReader));
                jsonReader.endObject();
            }
            jsonReader.endArray();
            ByteHandlePipeline pipeline = new ByteHandlePipeline(handlerList.toArray(new ByteHandler[handlerList.size()]));
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[4]));
            StorageType storage = StorageType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[5]));
            HashType hashing = HashType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[6]));
            boolean compression = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[7]));
            boolean pathSummary = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[8]));
            int ID = jsonReader.nextInt();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[9]));
            boolean deweyIDsStored = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            assert (name.equals(JSONNAMES[10]));
            Class<?> persistenterClazz = Class.forName(jsonReader.nextString());
            Constructor<?> persistenterConstr = persistenterClazz.getConstructors()[0];
            RecordPersister persistenter = (RecordPersister)persistenterConstr.newInstance(new Object[0]);
            jsonReader.endObject();
            jsonReader.close();
            fileReader.close();
            DatabaseConfiguration dbConfig = DatabaseConfiguration.deserialize(file.getParent().getParent());
            Builder builder = new Builder(file.getFileName().toString());
            builder.byteHandlerPipeline(pipeline).hashKind(hashing).versioningApproach(revisioning).revisionsToRestore(revisionToRestore).storageType(storage).persistenter(persistenter).useTextCompression(compression).buildPathSummary(pathSummary).useDeweyIDs(deweyIDsStored);
            ResourceConfiguration config = new ResourceConfiguration(builder);
            config.setDatabaseConfiguration(dbConfig);
            return config.setID(ID);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new SirixIOException(e);
        }
    }

    public static final class Builder {
        private StorageType mType = STORAGE;
        private VersioningType mRevisionKind = VERSIONING;
        private HashType mHashKind = HASHKIND;
        private int mRevisionsToRestore = 3;
        private RecordPersister mPersistenter = PERSISTENTER;
        private final String mResource;
        private boolean mCompression;
        private ByteHandlePipeline mByteHandler;
        private boolean mUseDeweyIDs;
        private boolean mPathSummary;

        public Builder(String resource) {
            this.mResource = (String)Preconditions.checkNotNull((Object)resource);
            this.mPathSummary = true;
            this.mByteHandler = new ByteHandlePipeline(new SnappyCompressor());
        }

        public Builder storageType(StorageType type) {
            this.mType = (StorageType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public Builder persistenter(RecordPersister persistenter) {
            this.mPersistenter = (RecordPersister)Preconditions.checkNotNull((Object)persistenter);
            return this;
        }

        public Builder versioningApproach(VersioningType versioning) {
            this.mRevisionKind = (VersioningType)((Object)Preconditions.checkNotNull((Object)((Object)versioning)));
            return this;
        }

        public Builder hashKind(HashType hashKind) {
            this.mHashKind = (HashType)((Object)Preconditions.checkNotNull((Object)((Object)hashKind)));
            return this;
        }

        public Builder byteHandlerPipeline(ByteHandlePipeline byteHandler) {
            this.mByteHandler = (ByteHandlePipeline)Preconditions.checkNotNull((Object)byteHandler);
            return this;
        }

        public Builder revisionsToRestore(@Nonnegative int revisionsToRestore) {
            Preconditions.checkArgument((revisionsToRestore > 0 ? 1 : 0) != 0, (Object)"revisionsToRestore must be > 0!");
            this.mRevisionsToRestore = revisionsToRestore;
            return this;
        }

        public Builder useDeweyIDs(boolean useDeweyIDs) {
            this.mUseDeweyIDs = useDeweyIDs;
            return this;
        }

        public Builder useTextCompression(boolean useTextCompression) {
            this.mCompression = useTextCompression;
            return this;
        }

        public Builder buildPathSummary(boolean buildPathSummary) {
            this.mPathSummary = buildPathSummary;
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Type", (Object)this.mType).add("RevisionKind", (Object)this.mRevisionKind).add("HashKind", (Object)this.mHashKind).toString();
        }

        public ResourceConfiguration build() {
            return new ResourceConfiguration(this);
        }
    }

    public static enum ResourcePaths {
        DATA(Paths.get("data", new String[0]), true),
        TRANSACTION_INTENT_LOG(Paths.get("log", new String[0]), true),
        CONFIG_BINARY(Paths.get("ressetting.obj", new String[0]), false),
        INDEXES(Paths.get("indexes", new String[0]), true),
        ENCRYPTION_KEY(Paths.get("encryption", new String[0]), true);

        private final Path mPath;
        private final boolean mIsFolder;

        private ResourcePaths(Path path, boolean isFolder) {
            this.mPath = path;
            this.mIsFolder = isFolder;
        }

        public Path getPath() {
            return this.mPath;
        }

        public boolean isFolder() {
            return this.mIsFolder;
        }

        public static int compareStructure(Path file) {
            int existing = 0;
            for (ResourcePaths paths : ResourcePaths.values()) {
                Path currentFile = file.resolve(paths.getPath());
                if (!Files.exists(currentFile, new LinkOption[0])) continue;
                ++existing;
            }
            return existing - ResourcePaths.values().length;
        }
    }
}

