/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sirix.api.Transaction;
import org.sirix.api.TransactionManager;
import org.sirix.api.xml.XmlNodeTrx;

public final class TransactionImpl
implements Transaction {
    private final List<XmlNodeTrx> resourceTrxs = new ArrayList<XmlNodeTrx>();
    private final TransactionManager trxMgr;

    public TransactionImpl(TransactionManager trxMgr) {
        this.trxMgr = (TransactionManager)Preconditions.checkNotNull((Object)trxMgr);
    }

    @Override
    public Transaction commit() {
        XmlNodeTrx trx;
        int i;
        boolean failure = false;
        for (i = 0; i < this.resourceTrxs.size() && !failure; ++i) {
            trx = this.resourceTrxs.get(i);
            try {
                trx.commit();
                continue;
            }
            catch (Exception e) {
                trx.rollback();
                failure = true;
            }
        }
        if (i < this.resourceTrxs.size()) {
            for (int j = 0; j < i; ++j) {
                trx = this.resourceTrxs.get(i);
                trx.truncateTo(trx.getRevisionNumber() - 1);
            }
            while (i < this.resourceTrxs.size()) {
                XmlNodeTrx trx2 = this.resourceTrxs.get(i);
                trx2.rollback();
                ++i;
            }
        }
        this.resourceTrxs.clear();
        this.trxMgr.closeTransaction(this);
        return this;
    }

    @Override
    public Transaction rollback() {
        this.resourceTrxs.forEach(XmlNodeTrx::rollback);
        this.resourceTrxs.clear();
        this.trxMgr.closeTransaction(this);
        return this;
    }

    @Override
    public void close() {
        this.rollback();
    }

    @Override
    public Transaction add(XmlNodeTrx writer) {
        this.resourceTrxs.add((XmlNodeTrx)Preconditions.checkNotNull((Object)writer));
        return this;
    }

    @Override
    public long getId() {
        return 0L;
    }
}

