/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.json;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.json.JsonResourceStore;
import org.sirix.access.trx.node.AbstractResourceManager;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.json.JsonIndexController;
import org.sirix.access.trx.node.json.JsonNodeFactoryImpl;
import org.sirix.access.trx.node.json.JsonNodeReadOnlyTrxImpl;
import org.sirix.access.trx.node.json.JsonNodeTrxImpl;
import org.sirix.api.Database;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.cache.BufferManager;
import org.sirix.index.path.summary.PathSummaryWriter;
import org.sirix.io.Storage;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;

public final class JsonResourceManagerImpl
extends AbstractResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx>
implements JsonResourceManager,
InternalResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private final ConcurrentMap<Integer, JsonIndexController> mRtxIndexControllers = new ConcurrentHashMap<Integer, JsonIndexController>();
    private final ConcurrentMap<Integer, JsonIndexController> mWtxIndexControllers = new ConcurrentHashMap<Integer, JsonIndexController>();

    public JsonResourceManagerImpl(Database<JsonResourceManager> database, @Nonnull JsonResourceStore resourceStore, @Nonnull ResourceConfiguration resourceConf, @Nonnull BufferManager bufferManager, @Nonnull Storage storage, @Nonnull UberPage uberPage, @Nonnull Semaphore readSemaphore, @Nonnull Lock writeLock) {
        super(database, resourceStore, resourceConf, bufferManager, storage, uberPage, readSemaphore, writeLock);
    }

    @Override
    public JsonNodeReadOnlyTrx createNodeReadOnlyTrx(long nodeTrxId, PageReadOnlyTrx pageReadTrx, Node documentNode) {
        return new JsonNodeReadOnlyTrxImpl(this, nodeTrxId, pageReadTrx, (ImmutableJsonNode)((Object)documentNode));
    }

    @Override
    public JsonNodeTrx createNodeReadWriteTrx(long nodeTrxId, PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, int maxNodeCount, TimeUnit timeUnit, int maxTime, Node documentNode) {
        JsonNodeReadOnlyTrxImpl nodeReadTrx = new JsonNodeReadOnlyTrxImpl(this, nodeTrxId, pageWriteTrx, (ImmutableJsonNode)((Object)documentNode));
        JsonNodeFactoryImpl nodeFactory = new JsonNodeFactoryImpl(pageWriteTrx);
        boolean buildPathSummary = this.getResourceConfig().withPathSummary;
        PathSummaryWriter<JsonNodeReadOnlyTrx> pathSummaryWriter = buildPathSummary ? new PathSummaryWriter<JsonNodeReadOnlyTrx>(pageWriteTrx, this, nodeFactory, nodeReadTrx) : null;
        return new JsonNodeTrxImpl(nodeTrxId, this, nodeReadTrx, pathSummaryWriter, maxNodeCount, timeUnit, maxTime, documentNode, nodeFactory);
    }

    @Override
    public synchronized JsonIndexController getRtxIndexController(int revision) {
        JsonIndexController controller = (JsonIndexController)this.mRtxIndexControllers.get(revision);
        if (controller == null) {
            controller = new JsonIndexController();
            this.mRtxIndexControllers.put(revision, controller);
        }
        return controller;
    }

    @Override
    public synchronized JsonIndexController getWtxIndexController(int revision) {
        JsonIndexController controller = (JsonIndexController)this.mWtxIndexControllers.get(revision);
        if (controller == null) {
            controller = new JsonIndexController();
            this.mWtxIndexControllers.put(revision, controller);
        }
        return controller;
    }
}

