/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import org.brackit.xquery.atomic.QNm;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.xdm.TextNode;
import org.sirix.page.PageKind;
import org.sirix.settings.Fixed;

public enum InsertPos {
    ASFIRSTCHILD{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            StructNode moved;
            assert (fromNode != null);
            assert (toNode != null);
            assert (wtx != null);
            StructNode newParent = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getNodeKey(), PageKind.RECORDPAGE, -1);
            if (fromNode.getParentKey() != toNode.getNodeKey()) {
                newParent.incrementChildCount();
            }
            if (toNode.hasFirstChild()) {
                wtx.moveTo(toNode.getFirstChildKey());
                if (wtx.getKind() == Kind.TEXT && fromNode.getKind() == Kind.TEXT) {
                    StringBuilder builder = new StringBuilder(wtx.getValue());
                    wtx.moveTo(wtx.getRightSiblingKey());
                    TextNode moved2 = (TextNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                    moved2.setRightSiblingKey(wtx.getNodeKey());
                    wtx.moveTo(moved2.getNodeKey());
                    builder.insert(0, wtx.getValue());
                    wtx.setValue(builder.toString());
                    wtx.moveTo(toNode.getFirstChildKey());
                    wtx.remove();
                    wtx.moveTo(moved2.getRightSiblingKey());
                    StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareEntryForModification(wtx.getNodeKey(), PageKind.RECORDPAGE, -1);
                    rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                } else {
                    StructNode oldFirstChild = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getFirstChildKey(), PageKind.RECORDPAGE, -1);
                    oldFirstChild.setLeftSiblingKey(fromNode.getNodeKey());
                    StructNode moved3 = (StructNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                    moved3.setRightSiblingKey(oldFirstChild.getNodeKey());
                }
            } else {
                moved = (StructNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                moved.setRightSiblingKey(Fixed.NULL_NODE_KEY.getStandardProperty());
            }
            newParent = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getNodeKey(), PageKind.RECORDPAGE, -1);
            newParent.setFirstChildKey(fromNode.getNodeKey());
            moved = (StructNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
            moved.setLeftSiblingKey(Fixed.NULL_NODE_KEY.getStandardProperty());
            moved.setParentKey(toNode.getNodeKey());
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == Kind.ELEMENT || wtx.getKind() == Kind.XDM_DOCUMENT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsFirstChild(rtx.getName());
                    break;
                }
                case TEXT: {
                    assert (wtx.getKind() == Kind.ELEMENT);
                    wtx.insertTextAsFirstChild(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    }
    ,
    ASRIGHTSIBLING{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            StringBuilder builder;
            assert (fromNode != null);
            assert (toNode != null);
            assert (wtx != null);
            if (fromNode.getParentKey() != toNode.getParentKey()) {
                StructNode parentNode = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getParentKey(), PageKind.RECORDPAGE, -1);
                parentNode.incrementChildCount();
            }
            boolean hasMoved = wtx.moveTo(toNode.getRightSiblingKey()).hasMoved();
            if (fromNode.getKind() == Kind.TEXT && toNode.getKind() == Kind.TEXT) {
                wtx.moveTo(toNode.getNodeKey());
                builder = new StringBuilder(wtx.getValue());
                if (toNode.hasRightSibling()) {
                    StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareEntryForModification(wtx.getRightSiblingKey(), PageKind.RECORDPAGE, -1);
                    rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                }
                TextNode movedNode = (TextNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                movedNode.setRightSiblingKey(toNode.getRightSiblingKey());
                movedNode.setLeftSiblingKey(wtx.getLeftSiblingKey());
                wtx.moveTo(movedNode.getNodeKey());
                builder.append(wtx.getValue());
                wtx.setValue(builder.toString());
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
                wtx.moveTo(toNode.getNodeKey());
                wtx.remove();
            } else if (hasMoved && fromNode.getKind() == Kind.TEXT && wtx.getKind() == Kind.TEXT) {
                builder = new StringBuilder(wtx.getValue());
                StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareEntryForModification(wtx.getNodeKey(), PageKind.RECORDPAGE, -1);
                rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                TextNode movedNode = (TextNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                movedNode.setRightSiblingKey(rightSibling.getNodeKey());
                movedNode.setLeftSiblingKey(toNode.getNodeKey());
                wtx.moveTo(movedNode.getNodeKey());
                builder.insert(0, wtx.getValue());
                wtx.setValue(builder.toString());
                wtx.moveTo(toNode.getRightSiblingKey());
                wtx.remove();
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
            } else {
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareEntryForModification(toNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                long rightSiblKey = insertAnchor.getRightSiblingKey();
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
                if (rightSiblKey > -1L) {
                    StructNode oldRightSibling = (StructNode)wtx.getPageWtx().prepareEntryForModification(rightSiblKey, PageKind.RECORDPAGE, -1);
                    oldRightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                }
                StructNode movedNode = (StructNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
                movedNode.setRightSiblingKey(rightSiblKey);
                movedNode.setLeftSiblingKey(insertAnchor.getNodeKey());
            }
            StructNode movedNode = (StructNode)wtx.getPageWtx().prepareEntryForModification(fromNode.getNodeKey(), PageKind.RECORDPAGE, -1);
            movedNode.setParentKey(toNode.getParentKey());
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == Kind.ELEMENT || wtx.getKind() == Kind.TEXT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsRightSibling(rtx.getName());
                    break;
                }
                case TEXT: {
                    wtx.insertTextAsRightSibling(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    }
    ,
    ASNONSTRUCTURAL{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            throw new AssertionError((Object)"May never be invoked!");
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == Kind.ELEMENT);
            switch (rtx.getKind()) {
                case NAMESPACE: {
                    QNm name = rtx.getName();
                    wtx.insertNamespace(new QNm(name.getNamespaceURI(), name.getLocalName(), ""));
                    wtx.moveToParent();
                    break;
                }
                case ATTRIBUTE: {
                    wtx.insertAttribute(rtx.getName(), rtx.getValue());
                    wtx.moveToParent();
                    break;
                }
                default: {
                    throw new IllegalStateException("Only namespace- and attribute-nodes are permitted!");
                }
            }
        }
    }
    ,
    ASLEFTSIBLING{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            throw new UnsupportedOperationException();
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == Kind.ELEMENT || wtx.getKind() == Kind.TEXT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsLeftSibling(rtx.getName());
                    break;
                }
                case TEXT: {
                    wtx.insertTextAsLeftSibling(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    };


    abstract void processMove(StructNode var1, StructNode var2, XmlNodeTrx var3) throws SirixException;

    abstract void insertNode(XmlNodeTrx var1, XmlNodeReadOnlyTrx var2) throws SirixException;
}

