/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.brackit.xquery.xdm.DocumentException;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.IndexController;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.ResourceManager;
import org.sirix.cache.BufferManager;
import org.sirix.cache.Cache;
import org.sirix.cache.IndexLogKey;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Reader;
import org.sirix.node.DeletedNode;
import org.sirix.node.Kind;
import org.sirix.node.interfaces.Record;
import org.sirix.page.CASPage;
import org.sirix.page.IndirectPage;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.PagePersister;
import org.sirix.page.PageReference;
import org.sirix.page.PathPage;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.SerializationType;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;
import org.sirix.settings.Fixed;
import org.sirix.settings.VersioningType;

public final class PageReadTrxImpl
implements PageReadOnlyTrx {
    private final Reader mPageReader;
    private final UberPage mUberPage;
    private final RevisionRootPage mRootPage;
    private final LoadingCache<IndexLogKey, PageContainer> mNodeCache;
    private final LoadingCache<PageReference, Page> mPageCache;
    protected final InternalResourceManager<?, ?> mResourceManager;
    private final NamePage mNamePage;
    private boolean mClosed;
    final ResourceConfiguration mResourceConfig;
    private final IndexController<?, ?> mIndexController;
    private final BufferManager mResourceBufferManager;
    private final TransactionIntentLog mTrxIntentLog;
    private long mTrxId;

    public PageReadTrxImpl(long trxId, InternalResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceManager, UberPage uberPage, @Nonnegative int revision, Reader reader, @Nullable TransactionIntentLog trxIntentLog, @Nullable IndexController<?, ?> indexController, @Nonnull BufferManager bufferManager) {
        Path indexes;
        Preconditions.checkArgument((revision >= 0 ? 1 : 0) != 0, (Object)"Revision must be >= 0.");
        Preconditions.checkArgument((trxId > 0L ? 1 : 0) != 0, (Object)"Transaction-ID must be >= 0.");
        this.mTrxId = trxId;
        this.mResourceBufferManager = (BufferManager)Preconditions.checkNotNull((Object)bufferManager);
        this.mTrxIntentLog = trxIntentLog;
        this.mClosed = false;
        this.mResourceConfig = resourceManager.getResourceConfig();
        IndexController<Object, Object> indexController2 = this.mIndexController = indexController == null ? resourceManager.getRtxIndexController(revision) : indexController;
        if (indexController == null && Files.exists(indexes = resourceManager.getResourceConfig().resourcePath.resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(String.valueOf(revision) + ".xml"), new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(indexes.toFile());){
                this.mIndexController.getIndexes().init(IndexController.deserialize(in).getFirstChild());
            }
            catch (IOException | DocumentException | SirixException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
        this.mResourceManager = (InternalResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mPageReader = (Reader)Preconditions.checkNotNull((Object)reader);
        this.mUberPage = (UberPage)Preconditions.checkNotNull((Object)uberPage);
        final PageReadTrxImpl pageReadTrx = this;
        this.mNodeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5000L, TimeUnit.SECONDS).expireAfterAccess(5000L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<IndexLogKey, PageContainer>(){

            public PageContainer load(IndexLogKey key) {
                return pageReadTrx.getRecordPageContainer(key.getRecordPageKey(), key.getIndex(), key.getIndexType());
            }
        });
        CacheBuilder pageCacheBuilder = CacheBuilder.newBuilder();
        this.mPageCache = pageCacheBuilder.build((CacheLoader)new CacheLoader<PageReference, Page>(){

            public Page load(PageReference reference) {
                Page page = reference.getPage();
                if (page == null) {
                    if (PageReadTrxImpl.this.mTrxIntentLog != null) {
                        PageContainer cont = PageReadTrxImpl.this.mTrxIntentLog.get(reference, pageReadTrx);
                        Page page2 = page = cont == null ? null : cont.getComplete();
                    }
                    if (page == null && (page = PageReadTrxImpl.this.mPageReader.read(reference, pageReadTrx)) != null && PageReadTrxImpl.this.mTrxIntentLog == null) {
                        PageReadTrxImpl.this.mResourceBufferManager.getPageCache().put(reference, page);
                        reference.setPage(page);
                    }
                }
                return page;
            }
        });
        this.mRootPage = this.loadRevRoot(revision);
        assert (this.mRootPage != null) : "root page must not be null!";
        this.mNamePage = this.getNamePage(this.mRootPage);
    }

    @Override
    public long getTrxId() {
        this.assertNotClosed();
        return this.mTrxId;
    }

    @Override
    public ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> getResourceManager() {
        this.assertNotClosed();
        return this.mResourceManager;
    }

    final void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Transaction is already closed.");
        }
    }

    public Optional<Record> getRecord(long nodeKey, PageKind pageKind, @Nonnegative int index) {
        PageContainer cont;
        Preconditions.checkNotNull((Object)((Object)pageKind));
        this.assertNotClosed();
        if (nodeKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return Optional.empty();
        }
        long recordPageKey = this.pageKey(nodeKey);
        try {
            switch (pageKind) {
                case RECORDPAGE: 
                case PATHSUMMARYPAGE: 
                case PATHPAGE: 
                case CASPAGE: 
                case NAMEPAGE: {
                    cont = (PageContainer)this.mNodeCache.get((Object)new IndexLogKey(pageKind, recordPageKey, index));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new SirixIOException(e.getCause());
        }
        if (PageContainer.emptyInstance().equals(cont)) {
            return Optional.empty();
        }
        Record retVal = ((UnorderedKeyValuePage)cont.getComplete()).getValue(nodeKey);
        return this.checkItemIfDeleted(retVal);
    }

    final Optional<Record> checkItemIfDeleted(@Nullable Record toCheck) {
        if (toCheck instanceof DeletedNode) {
            return Optional.empty();
        }
        return Optional.ofNullable(toCheck);
    }

    @Override
    public String getName(int nameKey, Kind nodeKind) {
        this.assertNotClosed();
        return this.mNamePage.getName(nameKey, nodeKind);
    }

    @Override
    public final byte[] getRawName(int pNameKey, Kind pNodeKind) {
        this.assertNotClosed();
        return this.mNamePage.getRawName(pNameKey, pNodeKind);
    }

    @Override
    public void clearCaches() {
        this.assertNotClosed();
        this.mNodeCache.invalidateAll();
        this.mPageCache.invalidateAll();
    }

    @Override
    public void closeCaches() {
        this.assertNotClosed();
    }

    @Override
    public RevisionRootPage loadRevRoot(@Nonnegative int revisionKey) throws SirixIOException {
        Preconditions.checkArgument((revisionKey >= 0 && revisionKey <= this.mResourceManager.getMostRecentRevisionNumber() ? 1 : 0) != 0, (String)"%s must be >= 0 and <= last stored revision (%s)!", (int)revisionKey, (int)this.mResourceManager.getMostRecentRevisionNumber());
        if (this.mTrxIntentLog == null) {
            Cache<Integer, RevisionRootPage> cache = this.mResourceBufferManager.getRevisionRootPageCache();
            RevisionRootPage revisionRootPage = cache.get(revisionKey);
            if (revisionRootPage == null) {
                revisionRootPage = this.mPageReader.readRevisionRootPage(revisionKey, this);
                cache.put(revisionKey, revisionRootPage);
            }
            return revisionRootPage;
        }
        PageReference reference = this.getPageReferenceForPage(this.mUberPage.getIndirectPageReference(), revisionKey, this.mUberPage.getRevisionNumber(), -1, PageKind.UBERPAGE);
        try {
            RevisionRootPage page = null;
            if (this.mTrxIntentLog != null) {
                PageContainer cont = this.mTrxIntentLog.get(reference, this);
                RevisionRootPage revisionRootPage = page = cont == null ? null : (RevisionRootPage)cont.getComplete();
            }
            if (page == null) {
                assert (reference.getKey() != -15L || reference.getLogKey() != -15 || reference.getPersistentLogKey() != -15L);
                page = (RevisionRootPage)this.mPageCache.get((Object)reference);
            }
            return page;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new SirixIOException(e.getCause());
        }
    }

    @Override
    public final NamePage getNamePage(RevisionRootPage revisionRoot) throws SirixIOException {
        this.assertNotClosed();
        return (NamePage)this.getPage(revisionRoot.getNamePageReference(), PageKind.NAMEPAGE);
    }

    @Override
    public final PathSummaryPage getPathSummaryPage(RevisionRootPage revisionRoot) throws SirixIOException {
        this.assertNotClosed();
        return (PathSummaryPage)this.getPage(revisionRoot.getPathSummaryPageReference(), PageKind.PATHSUMMARYPAGE);
    }

    @Override
    public final PathPage getPathPage(RevisionRootPage revisionRoot) throws SirixIOException {
        this.assertNotClosed();
        return (PathPage)this.getPage(revisionRoot.getPathPageReference(), PageKind.PATHPAGE);
    }

    @Override
    public final CASPage getCASPage(RevisionRootPage revisionRoot) throws SirixIOException {
        this.assertNotClosed();
        return (CASPage)this.getPage(revisionRoot.getCASPageReference(), PageKind.CASPAGE);
    }

    private Page getPage(PageReference reference, PageKind pageKind) throws SirixIOException {
        try {
            Page page = reference.getPage();
            if (page == null) {
                page = (Page)this.mPageCache.get((Object)reference);
                reference.setPage(page);
            }
            return page;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new SirixIOException(e.getCause());
        }
    }

    @Override
    public final UberPage getUberPage() {
        this.assertNotClosed();
        return this.mUberPage;
    }

    @Override
    public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer getRecordPageContainer(@Nonnegative Long recordPageKey, int index, PageKind pageKind) {
        this.assertNotClosed();
        Preconditions.checkArgument((recordPageKey >= 0L ? 1 : 0) != 0, (Object)"recordPageKey must not be negative!");
        Optional<PageReference> pageReferenceToRecordPage = this.getLeafPageReference((Long)Preconditions.checkNotNull((Object)recordPageKey), index, (PageKind)((Object)Preconditions.checkNotNull((Object)((Object)pageKind))));
        if (!pageReferenceToRecordPage.isPresent()) {
            return PageContainer.emptyInstance();
        }
        PageContainer recordPageContainerFromBuffer = this.mResourceBufferManager.getRecordPageCache().get(pageReferenceToRecordPage.get());
        if (recordPageContainerFromBuffer != null) {
            return recordPageContainerFromBuffer;
        }
        List<T> pages = this.getSnapshotPages(pageReferenceToRecordPage.get());
        if (pages.isEmpty()) {
            return PageContainer.emptyInstance();
        }
        int mileStoneRevision = this.mResourceConfig.numberOfRevisionsToRestore;
        VersioningType revisioning = this.mResourceConfig.revisioningType;
        T completePage = revisioning.combineRecordPages(pages, mileStoneRevision, this);
        PageContainer recordPageContainer = PageContainer.getInstance(completePage, this.clone((Page)completePage));
        if (this.mTrxIntentLog == null) {
            this.mResourceBufferManager.getRecordPageCache().put(pageReferenceToRecordPage.get(), recordPageContainer);
        }
        return recordPageContainer;
    }

    <E extends Page> E clone(E toClone) throws SirixIOException {
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            PagePersister pagePersister = new PagePersister();
            pagePersister.serializePage((DataOutput)output, toClone, SerializationType.TRANSACTION_INTENT_LOG);
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])output.toByteArray());
            return (E)pagePersister.deserializePage((DataInput)input, this, SerializationType.TRANSACTION_INTENT_LOG);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    final Optional<PageReference> getLeafPageReference(@Nonnegative long recordPageKey, int indexNumber, PageKind pageKind) {
        PageReference tmpRef = this.getPageReference(this.mRootPage, pageKind, indexNumber);
        long maxPageKey = this.getMaxPageIdInSubtree(pageKind, indexNumber);
        return Optional.ofNullable(this.getPageReferenceForPage(tmpRef, recordPageKey, maxPageKey, indexNumber, pageKind));
    }

    private long getMaxPageIdInSubtree(PageKind pageKind, int index) {
        long maxPageKey;
        RevisionRootPage revisionRootPage = this.getActualRevisionRootPage();
        switch (pageKind) {
            case UBERPAGE: {
                maxPageKey = this.mUberPage.getRevisionNumber();
                break;
            }
            case RECORDPAGE: {
                maxPageKey = revisionRootPage.getMaxNodeKey() >> 512;
                break;
            }
            case CASPAGE: {
                maxPageKey = this.getCASPage(revisionRootPage).getMaxNodeKey(index) >> 512;
                break;
            }
            case PATHPAGE: {
                maxPageKey = this.getPathPage(revisionRootPage).getMaxNodeKey(index) >> 512;
                break;
            }
            case NAMEPAGE: {
                maxPageKey = this.getNamePage(revisionRootPage).getMaxNodeKey(index) >> 512;
                break;
            }
            case PATHSUMMARYPAGE: {
                maxPageKey = this.getPathSummaryPage(revisionRootPage).getMaxNodeKey(index) >> 512;
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
        return maxPageKey;
    }

    final <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> List<T> getSnapshotPages(PageReference pageReference) {
        assert (pageReference != null);
        ResourceConfiguration config = this.mResourceManager.getResourceConfig();
        int revsToRestore = config.numberOfRevisionsToRestore;
        int[] revisionsToRead = config.revisioningType.getRevisionRoots(this.mRootPage.getRevision(), revsToRestore);
        ArrayList<KeyValuePage> pages = new ArrayList<KeyValuePage>(revisionsToRead.length);
        boolean first = true;
        for (int i = 0; i < revisionsToRead.length; ++i) {
            long refKeyToRecordPage = -15L;
            if (first) {
                first = false;
                refKeyToRecordPage = pageReference.getKey();
            } else {
                refKeyToRecordPage = ((KeyValuePage)pages.get(pages.size() - 1)).getPreviousReferenceKey();
            }
            if (refKeyToRecordPage == -15L) break;
            PageReference reference = new PageReference().setKey(refKeyToRecordPage);
            if (reference.getKey() == -15L) continue;
            KeyValuePage page = (KeyValuePage)this.mPageReader.read(reference, this);
            pages.add(page);
            if (page.size() == 512) break;
        }
        return pages;
    }

    PageReference getPageReference(RevisionRootPage revisionRoot, PageKind pageKind, int index) throws SirixIOException {
        assert (revisionRoot != null);
        PageReference ref = null;
        switch (pageKind) {
            case RECORDPAGE: {
                ref = revisionRoot.getIndirectPageReference();
                break;
            }
            case CASPAGE: {
                ref = this.getCASPage(revisionRoot).getIndirectPageReference(index);
                break;
            }
            case PATHPAGE: {
                ref = this.getPathPage(revisionRoot).getIndirectPageReference(index);
                break;
            }
            case NAMEPAGE: {
                ref = this.getNamePage(revisionRoot).getIndirectPageReference(index);
                break;
            }
            case PATHSUMMARYPAGE: {
                ref = this.getPathSummaryPage(revisionRoot).getIndirectPageReference(index);
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
        return ref;
    }

    @Override
    public IndirectPage dereferenceIndirectPageReference(PageReference reference) {
        try {
            IndirectPage page = null;
            if (this.mTrxIntentLog != null) {
                PageContainer cont = this.mTrxIntentLog.get(reference, this);
                IndirectPage indirectPage = page = cont == null ? null : (IndirectPage)cont.getComplete();
            }
            if (page == null) {
                page = (IndirectPage)reference.getPage();
            }
            if (page == null && (reference.getKey() != -15L || reference.getLogKey() != -15 || reference.getPersistentLogKey() != -15L)) {
                page = (IndirectPage)this.mPageCache.get((Object)reference);
            }
            return page;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new SirixIOException(e.getCause());
        }
    }

    @Override
    @Nullable
    public final PageReference getPageReferenceForPage(PageReference startReference, @Nonnegative long pageKey, @Nonnegative long maxPageKey, int indexNumber, @Nonnull PageKind pageKind) {
        this.assertNotClosed();
        PageReference reference = (PageReference)Preconditions.checkNotNull((Object)startReference);
        Preconditions.checkArgument((pageKey >= 0L ? 1 : 0) != 0, (Object)"page key must be >= 0!");
        Preconditions.checkArgument((maxPageKey >= 0L ? 1 : 0) != 0, (Object)"max page key must be >= 0!");
        int offset = 0;
        long levelKey = pageKey;
        int[] inpLevelPageCountExp = this.mUberPage.getPageCountExp(pageKind);
        int maxHeight = this.getCurrentMaxIndirectPageTreeLevel(pageKind, indexNumber, null);
        int height = inpLevelPageCountExp.length;
        for (int level = inpLevelPageCountExp.length - maxHeight; level < height; ++level) {
            IndirectPage derefPage = this.dereferenceIndirectPageReference(reference);
            if (derefPage == null) {
                reference = null;
                break;
            }
            offset = (int)(levelKey >> inpLevelPageCountExp[level]);
            levelKey -= (long)(offset << inpLevelPageCountExp[level]);
            try {
                reference = derefPage.getReference(offset);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new SirixIOException("Node key isn't supported, it's too big!");
            }
        }
        return reference;
    }

    @Override
    public long pageKey(@Nonnegative long recordKey) {
        this.assertNotClosed();
        Preconditions.checkArgument((recordKey >= 0L ? 1 : 0) != 0, (Object)"recordKey must not be negative!");
        return recordKey >> 9;
    }

    @Override
    public int getCurrentMaxIndirectPageTreeLevel(PageKind pageKind, int index, RevisionRootPage revisionRootPage) {
        int maxLevel;
        RevisionRootPage currentRevisionRootPage = revisionRootPage == null ? this.mRootPage : revisionRootPage;
        switch (pageKind) {
            case UBERPAGE: {
                maxLevel = this.mUberPage.getCurrentMaxLevelOfIndirectPages();
                break;
            }
            case RECORDPAGE: {
                maxLevel = currentRevisionRootPage.getCurrentMaxLevelOfIndirectPages();
                break;
            }
            case CASPAGE: {
                maxLevel = this.getCASPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
                break;
            }
            case PATHPAGE: {
                maxLevel = this.getPathPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
                break;
            }
            case NAMEPAGE: {
                maxLevel = this.getNamePage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
                break;
            }
            case PATHSUMMARYPAGE: {
                maxLevel = this.getPathSummaryPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
        return maxLevel;
    }

    @Override
    public RevisionRootPage getActualRevisionRootPage() {
        this.assertNotClosed();
        return this.mRootPage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Session", this.mResourceManager).add("PageReader", (Object)this.mPageReader).add("UberPage", (Object)this.mUberPage).add("RevRootPage", (Object)this.mRootPage).toString();
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            this.closeCaches();
            this.mPageReader.close();
            if (!this.mResourceManager.getNodeReadTrxByTrxId(this.mTrxId).isPresent()) {
                this.mResourceManager.closePageReadTransaction(this.mTrxId);
            }
            this.mClosed = true;
        }
    }

    @Override
    public int getNameCount(int key, @Nonnull Kind kind) {
        this.assertNotClosed();
        return this.mNamePage.getCount(key, kind);
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.mRootPage.getRevision();
    }

    @Override
    public Reader getReader() {
        return this.mPageReader;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        return this.mRootPage.getCommitCredentials();
    }
}

