/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.page;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.IndexController;
import org.sirix.access.trx.node.Restore;
import org.sirix.access.trx.page.AbstractForwardingPageReadOnlyTrx;
import org.sirix.access.trx.page.PageReadTrxImpl;
import org.sirix.access.trx.page.TreeModifier;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Writer;
import org.sirix.node.DeletedNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.interfaces.Record;
import org.sirix.page.CASPage;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.PathPage;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;
import org.sirix.settings.Fixed;
import org.sirix.settings.VersioningType;
import org.sirix.utils.NamePageHash;

final class PageTrxImpl
extends AbstractForwardingPageReadOnlyTrx
implements PageTrx<Long, Record, UnorderedKeyValuePage> {
    private final Writer mPageWriter;
    TransactionIntentLog mLog;
    private final RevisionRootPage mNewRoot;
    private final PageReadTrxImpl mPageRtx;
    private Restore mRestore = Restore.NO;
    private boolean mIsClosed;
    private final IndexController<?, ?> mIndexController;
    private final TreeModifier mTreeModifier;
    private final boolean mIsBoundToNodeTrx;

    PageTrxImpl(TreeModifier treeModifier, Writer writer, TransactionIntentLog log, RevisionRootPage revisionRootPage, PageReadTrxImpl pageRtx, IndexController<?, ?> indexController, boolean isBoundToNodeTrx) {
        this.mTreeModifier = (TreeModifier)Preconditions.checkNotNull((Object)treeModifier);
        this.mPageWriter = (Writer)Preconditions.checkNotNull((Object)writer);
        this.mLog = (TransactionIntentLog)Preconditions.checkNotNull((Object)log);
        this.mNewRoot = (RevisionRootPage)Preconditions.checkNotNull((Object)revisionRootPage);
        this.mPageRtx = (PageReadTrxImpl)Preconditions.checkNotNull((Object)pageRtx);
        this.mIndexController = (IndexController)Preconditions.checkNotNull(indexController);
        this.mIsBoundToNodeTrx = isBoundToNodeTrx;
    }

    @Override
    public TransactionIntentLog getLog() {
        return this.mLog;
    }

    @Override
    public void restore(Restore restore) {
        this.mRestore = (Restore)((Object)Preconditions.checkNotNull((Object)((Object)restore)));
    }

    @Override
    public Record prepareEntryForModification(@Nonnegative Long recordKey, PageKind pageKind, int index) {
        this.mPageRtx.assertNotClosed();
        Preconditions.checkNotNull((Object)recordKey);
        Preconditions.checkArgument((recordKey >= 0L ? 1 : 0) != 0, (Object)"recordKey must be >= 0!");
        Preconditions.checkNotNull((Object)((Object)pageKind));
        long recordPageKey = this.mPageRtx.pageKey(recordKey);
        PageContainer cont = this.prepareRecordPage(recordPageKey, index, pageKind);
        Record record = ((UnorderedKeyValuePage)cont.getModified()).getValue(recordKey);
        if (record == null) {
            Record oldRecord = ((UnorderedKeyValuePage)cont.getComplete()).getValue(recordKey);
            if (oldRecord == null) {
                throw new SirixIOException("Cannot retrieve record from cache!");
            }
            record = oldRecord;
            ((UnorderedKeyValuePage)cont.getModified()).setEntry(record.getNodeKey(), record);
        }
        return record;
    }

    @Override
    public Record createEntry(Long key, Record record, PageKind pageKind, int index) {
        long recordKey;
        this.mPageRtx.assertNotClosed();
        switch (pageKind) {
            case RECORDPAGE: {
                recordKey = this.mNewRoot.incrementAndGetMaxNodeKey();
                break;
            }
            case PATHSUMMARYPAGE: {
                PathSummaryPage pathSummaryPage = (PathSummaryPage)this.mNewRoot.getPathSummaryPageReference().getPage();
                recordKey = pathSummaryPage.incrementAndGetMaxNodeKey(index);
                break;
            }
            case CASPAGE: {
                CASPage casPage = (CASPage)this.mNewRoot.getCASPageReference().getPage();
                recordKey = casPage.incrementAndGetMaxNodeKey(index);
                break;
            }
            case PATHPAGE: {
                PathPage pathPage = (PathPage)this.mNewRoot.getPathPageReference().getPage();
                recordKey = pathPage.incrementAndGetMaxNodeKey(index);
                break;
            }
            case NAMEPAGE: {
                NamePage namePage = (NamePage)this.mNewRoot.getNamePageReference().getPage();
                recordKey = namePage.incrementAndGetMaxNodeKey(index);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        long recordPageKey = this.mPageRtx.pageKey(recordKey);
        PageContainer cont = this.prepareRecordPage(recordPageKey, index, pageKind);
        KeyValuePage modified = (KeyValuePage)cont.getModified();
        modified.setEntry(record.getNodeKey(), record);
        return record;
    }

    @Override
    public void removeEntry(Long recordKey, @Nonnull PageKind pageKind, int index) {
        this.mPageRtx.assertNotClosed();
        long nodePageKey = this.mPageRtx.pageKey(recordKey);
        PageContainer cont = this.prepareRecordPage(nodePageKey, index, pageKind);
        Optional<Record> node = this.getRecord(recordKey, pageKind, index);
        if (!node.isPresent()) {
            throw new IllegalStateException("Node not found!");
        }
        Record nodeToDel = node.get();
        DeletedNode delNode = new DeletedNode(new NodeDelegate(nodeToDel.getNodeKey(), -1L, -1L, -1L, null));
        ((UnorderedKeyValuePage)cont.getModified()).setEntry(delNode.getNodeKey(), (Record)delNode);
        ((UnorderedKeyValuePage)cont.getComplete()).setEntry(delNode.getNodeKey(), (Record)delNode);
    }

    public Optional<Record> getRecord(@Nonnegative long recordKey, PageKind pageKind, @Nonnegative int index) {
        this.mPageRtx.assertNotClosed();
        Preconditions.checkArgument((recordKey >= Fixed.NULL_NODE_KEY.getStandardProperty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)pageKind));
        long recordPageKey = this.mPageRtx.pageKey(recordKey);
        PageContainer pageCont = this.prepareRecordPage(recordPageKey, index, pageKind);
        if (pageCont.equals(PageContainer.emptyInstance())) {
            return this.mPageRtx.getRecord(recordKey, pageKind, index);
        }
        Record node = ((UnorderedKeyValuePage)pageCont.getModified()).getValue(recordKey);
        if (node == null) {
            node = ((UnorderedKeyValuePage)pageCont.getComplete()).getValue(recordKey);
        }
        return this.mPageRtx.checkItemIfDeleted(node);
    }

    @Override
    public String getName(int nameKey, Kind nodeKind) {
        this.mPageRtx.assertNotClosed();
        NamePage currentNamePage = this.getNamePage(this.mNewRoot);
        return currentNamePage == null || currentNamePage.getName(nameKey, nodeKind) == null ? this.mPageRtx.getName(nameKey, nodeKind) : currentNamePage.getName(nameKey, nodeKind);
    }

    @Override
    public int createNameKey(@Nullable String name, Kind nodeKind) {
        this.mPageRtx.assertNotClosed();
        Preconditions.checkNotNull((Object)nodeKind);
        String string = name == null ? "" : name;
        int nameKey = NamePageHash.generateHashForString(string);
        NamePage namePage = this.getNamePage(this.mNewRoot);
        namePage.setName(nameKey, string, nodeKind);
        return nameKey;
    }

    @Override
    public void commit(@Nullable PageReference reference) {
        if (reference == null) {
            return;
        }
        PageContainer container = this.mLog.get(reference, this.mPageRtx);
        Page page = null;
        if (container != null) {
            page = container.getModified();
        }
        if (page == null) {
            return;
        }
        reference.setPage(page);
        page.commit(this);
        this.mPageWriter.write(reference);
        reference.setPage(null);
    }

    @Override
    public UberPage commit(String commitMessage) {
        this.mPageRtx.assertNotClosed();
        this.mPageRtx.mResourceManager.getCommitLock().lock();
        Path commitFile = this.mPageRtx.mResourceManager.getCommitFile();
        commitFile.toFile().deleteOnExit();
        while (!Files.exists(commitFile, new LinkOption[0])) {
            try {
                Files.createFile(commitFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
        PageReference uberPageReference = new PageReference();
        UberPage uberPage = this.getUberPage();
        uberPageReference.setPage(uberPage);
        int revision = uberPage.getRevisionNumber();
        if (commitMessage == null) {
            uberPage.commit(this);
        } else {
            uberPage.commit(commitMessage, this);
        }
        uberPageReference.setPage(uberPage);
        this.mPageWriter.writeUberPageReference(uberPageReference);
        uberPageReference.setPage(null);
        Path indexes = this.mPageRtx.mResourceConfig.resourcePath.resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(String.valueOf(revision) + ".xml");
        if (!Files.exists(indexes, new LinkOption[0])) {
            try {
                Files.createFile(indexes, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
        try (FileOutputStream out = new FileOutputStream(indexes.toFile());){
            this.mIndexController.serialize(out);
        }
        catch (IOException e) {
            throw new SirixIOException("Index definitions couldn't be serialized!", e);
        }
        this.mLog.truncate();
        try {
            Files.delete(commitFile);
        }
        catch (IOException e) {
            throw new SirixIOException("Commit file couldn't be deleted!");
        }
        UberPage commitedUberPage = (UberPage)this.mPageWriter.read(this.mPageWriter.readUberPageReference(), this.mPageRtx);
        this.mPageRtx.mResourceManager.getCommitLock().unlock();
        return commitedUberPage;
    }

    @Override
    public UberPage commit() {
        return this.commit((String)null);
    }

    @Override
    public UberPage rollback() {
        this.mPageRtx.assertNotClosed();
        this.mLog.truncate();
        return (UberPage)this.mPageWriter.read(this.mPageWriter.readUberPageReference(), this.mPageRtx);
    }

    @Override
    public void close() {
        if (!this.mIsClosed) {
            this.mPageRtx.assertNotClosed();
            UberPage lastUberPage = (UberPage)this.mPageWriter.read(this.mPageWriter.readUberPageReference(), this.mPageRtx);
            this.mPageRtx.mResourceManager.setLastCommittedUberPage(lastUberPage);
            if (!this.mIsBoundToNodeTrx) {
                this.mPageRtx.mResourceManager.closePageWriteTransaction(this.mPageRtx.getTrxId());
            }
            this.mPageRtx.clearCaches();
            this.mPageRtx.closeCaches();
            this.closeCaches();
            this.mPageRtx.close();
            this.mPageWriter.close();
            this.mIsClosed = true;
        }
    }

    @Override
    public void clearCaches() {
        this.mPageRtx.assertNotClosed();
        this.mPageRtx.clearCaches();
        this.mLog.clear();
    }

    @Override
    public void closeCaches() {
        this.mPageRtx.assertNotClosed();
        this.mPageRtx.closeCaches();
        this.mLog.close();
    }

    private PageContainer prepareRecordPage(@Nonnegative long recordPageKey, int indexNumber, PageKind pageKind) {
        assert (recordPageKey >= 0L);
        assert (pageKind != null);
        long maxNodeKey = this.getMaxNodeKey(indexNumber, pageKind, this.mNewRoot);
        long maxPageKey = maxNodeKey >> 1;
        PageReference pageReference = this.mPageRtx.getPageReference(this.mNewRoot, pageKind, indexNumber);
        PageReference reference = this.mTreeModifier.prepareLeafOfTree(this.mPageRtx, this.mLog, this.getUberPage().getPageCountExp(pageKind), pageReference, recordPageKey, maxPageKey, indexNumber, pageKind, this.mNewRoot);
        PageContainer pageContainer = this.mLog.get(reference, this.mPageRtx);
        if (pageContainer.equals(PageContainer.emptyInstance())) {
            if (reference.getKey() == -15L) {
                UnorderedKeyValuePage completePage = new UnorderedKeyValuePage(recordPageKey, pageKind, -15L, this.mPageRtx);
                UnorderedKeyValuePage modifyPage = this.mPageRtx.clone(completePage);
                pageContainer = PageContainer.getInstance(completePage, modifyPage);
            } else {
                pageContainer = this.dereferenceRecordPageForModification(reference);
            }
            assert (pageContainer != null);
            switch (pageKind) {
                case RECORDPAGE: 
                case PATHSUMMARYPAGE: 
                case CASPAGE: 
                case PATHPAGE: 
                case NAMEPAGE: {
                    this.appendLogRecord(reference, pageContainer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Page kind not known!");
                }
            }
        }
        return pageContainer;
    }

    private long getMaxNodeKey(int index, PageKind pageKind, RevisionRootPage revisionRoot) {
        long maxNodeKey;
        switch (pageKind) {
            case RECORDPAGE: {
                maxNodeKey = revisionRoot.getMaxNodeKey();
                break;
            }
            case CASPAGE: {
                maxNodeKey = this.getCASPage(revisionRoot).getMaxNodeKey(index);
                break;
            }
            case PATHPAGE: {
                maxNodeKey = this.getPathPage(revisionRoot).getMaxNodeKey(index);
                break;
            }
            case NAMEPAGE: {
                maxNodeKey = this.getNamePage(revisionRoot).getMaxNodeKey(index);
                break;
            }
            case PATHSUMMARYPAGE: {
                maxNodeKey = this.getPathSummaryPage(revisionRoot).getMaxNodeKey(index);
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
        return maxNodeKey;
    }

    private PageContainer dereferenceRecordPageForModification(PageReference reference) {
        List revs = this.mPageRtx.getSnapshotPages(reference);
        VersioningType revisioning = this.mPageRtx.mResourceManager.getResourceConfig().revisioningType;
        int mileStoneRevision = this.mPageRtx.mResourceManager.getResourceConfig().numberOfRevisionsToRestore;
        return revisioning.combineRecordPagesForModification(revs, mileStoneRevision, this.mPageRtx, reference);
    }

    @Override
    public RevisionRootPage getActualRevisionRootPage() {
        return this.mNewRoot;
    }

    @Override
    protected PageReadOnlyTrx delegate() {
        return this.mPageRtx;
    }

    @Override
    public PageReadOnlyTrx getPageReadTrx() {
        return this.mPageRtx;
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> appendLogRecord(PageReference reference, PageContainer pageContainer) {
        Preconditions.checkNotNull((Object)pageContainer);
        this.mLog.put(reference, pageContainer);
        return this;
    }

    @Override
    public PageContainer getLogRecord(PageReference reference) {
        Preconditions.checkNotNull((Object)reference);
        return this.mLog.get(reference, this.mPageRtx);
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> truncateTo(int revision) {
        this.mPageWriter.truncateTo(revision);
        return this;
    }

    @Override
    public long getTrxId() {
        return this.mPageRtx.getTrxId();
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        return this.mPageRtx.getCommitCredentials();
    }
}

