/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.page;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.brackit.xquery.xdm.DocumentException;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.IndexController;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.page.PageReadTrxImpl;
import org.sirix.access.trx.page.PageTrxImpl;
import org.sirix.access.trx.page.TransactionIntentLogFactoryImpl;
import org.sirix.access.trx.page.TreeModifierImpl;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageTrx;
import org.sirix.cache.BufferManager;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Writer;
import org.sirix.node.interfaces.Record;
import org.sirix.page.CASPage;
import org.sirix.page.IndirectPage;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.PathPage;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;

public final class PageWriteTrxFactory {
    public PageTrx<Long, Record, UnorderedKeyValuePage> createPageWriteTrx(InternalResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceManager, UberPage uberPage, Writer writer, @Nonnegative long trxId, @Nonnegative int representRev, @Nonnegative int lastStoredRev, @Nonnegative int lastCommitedRev, @Nonnull BufferManager bufferManager, boolean isBoundToNodeTrx) {
        boolean usePathSummary = resourceManager.getResourceConfig().withPathSummary;
        Object indexController = resourceManager.getWtxIndexController(representRev);
        Path indexes = resourceManager.getResourceConfig().resourcePath.resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(String.valueOf(lastStoredRev) + ".xml");
        if (Files.exists(indexes, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(indexes.toFile());){
                indexController.getIndexes().init(IndexController.deserialize(in).getFirstChild());
            }
            catch (IOException | DocumentException | SirixException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
        TreeModifierImpl treeModifier = new TreeModifierImpl();
        TransactionIntentLogFactoryImpl logFactory = new TransactionIntentLogFactoryImpl();
        TransactionIntentLog log = logFactory.createTrxIntentLog(resourceManager.getResourceConfig());
        if (uberPage.isBootstrap()) {
            uberPage.createRevisionTree(log);
        }
        PageReadTrxImpl pageRtx = new PageReadTrxImpl(trxId, resourceManager, uberPage, representRev, writer, log, (IndexController<?, ?>)indexController, bufferManager);
        RevisionRootPage lastCommitedRoot = pageRtx.loadRevRoot(lastCommitedRev);
        RevisionRootPage newRevisionRootPage = treeModifier.preparePreviousRevisionRootPage(uberPage, pageRtx, log, representRev, lastStoredRev);
        newRevisionRootPage.setMaxNodeKey(lastCommitedRoot.getMaxNodeKey());
        newRevisionRootPage.createNodeTree(pageRtx, log);
        if (usePathSummary) {
            PathSummaryPage page = pageRtx.getPathSummaryPage(newRevisionRootPage);
            page.createPathSummaryTree(pageRtx, 0, log);
            if (PageContainer.emptyInstance().equals(log.get(newRevisionRootPage.getPathSummaryPageReference(), pageRtx))) {
                log.put(newRevisionRootPage.getPathSummaryPageReference(), PageContainer.getInstance(page, page));
            }
        }
        if (!uberPage.isBootstrap()) {
            if (PageContainer.emptyInstance().equals(log.get(newRevisionRootPage.getNamePageReference(), pageRtx))) {
                NamePage namePage = pageRtx.getNamePage(newRevisionRootPage);
                log.put(newRevisionRootPage.getNamePageReference(), PageContainer.getInstance(namePage, namePage));
            }
            if (PageContainer.emptyInstance().equals(log.get(newRevisionRootPage.getCASPageReference(), pageRtx))) {
                CASPage casPage = pageRtx.getCASPage(newRevisionRootPage);
                log.put(newRevisionRootPage.getCASPageReference(), PageContainer.getInstance(casPage, casPage));
            }
            if (PageContainer.emptyInstance().equals(log.get(newRevisionRootPage.getPathPageReference(), pageRtx))) {
                PathPage pathPage = pageRtx.getPathPage(newRevisionRootPage);
                log.put(newRevisionRootPage.getPathPageReference(), PageContainer.getInstance(pathPage, pathPage));
            }
            IndirectPage indirectPage = pageRtx.dereferenceIndirectPageReference(newRevisionRootPage.getIndirectPageReference());
            log.put(newRevisionRootPage.getIndirectPageReference(), PageContainer.getInstance(indirectPage, indirectPage));
            PageReference revisionRootPageReference = treeModifier.prepareLeafOfTree(pageRtx, log, uberPage.getPageCountExp(PageKind.UBERPAGE), uberPage.getIndirectPageReference(), uberPage.getRevisionNumber(), uberPage.getRevisionNumber(), -1, PageKind.UBERPAGE, newRevisionRootPage);
            log.put(revisionRootPageReference, PageContainer.getInstance(newRevisionRootPage, newRevisionRootPage));
        }
        return new PageTrxImpl(treeModifier, writer, log, newRevisionRootPage, pageRtx, (IndexController<?, ?>)indexController, isBoundToNodeTrx);
    }
}

