/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.page;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.page.TransactionIntentLogFactory;
import org.sirix.cache.PersistentFileCache;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.io.bytepipe.ByteHandlePipeline;
import org.sirix.io.file.FileWriter;
import org.sirix.page.PagePersister;
import org.sirix.page.SerializationType;

final class TransactionIntentLogFactoryImpl
implements TransactionIntentLogFactory {
    @Override
    public TransactionIntentLog createTrxIntentLog(ResourceConfiguration resourceConfig) {
        Path logFile = resourceConfig.getResource().resolve(ResourceConfiguration.ResourcePaths.TRANSACTION_INTENT_LOG.getPath()).resolve("intent-log");
        try {
            if (Files.exists(logFile, new LinkOption[0])) {
                Files.delete(logFile);
                Files.createFile(logFile, new FileAttribute[0]);
            }
            RandomAccessFile file = new RandomAccessFile(logFile.toFile(), "rw");
            FileWriter fileWriter = new FileWriter(file, null, new ByteHandlePipeline(resourceConfig.byteHandlePipeline), SerializationType.TRANSACTION_INTENT_LOG, new PagePersister());
            PersistentFileCache persistentFileCache = new PersistentFileCache(fileWriter);
            return new TransactionIntentLog(persistentFileCache);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

