/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.page;

import javax.annotation.Nonnegative;
import org.sirix.access.trx.page.PageReadTrxImpl;
import org.sirix.access.trx.page.TreeModifier;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.page.IndirectPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.UberPage;

public final class TreeModifierImpl
implements TreeModifier {
    TreeModifierImpl() {
    }

    @Override
    public RevisionRootPage preparePreviousRevisionRootPage(UberPage uberPage, PageReadTrxImpl pageRtx, TransactionIntentLog log, @Nonnegative int baseRevision, @Nonnegative int representRevision) {
        if (uberPage.isBootstrap()) {
            RevisionRootPage revisionRootPage = pageRtx.loadRevRoot(baseRevision);
            return revisionRootPage;
        }
        RevisionRootPage revisionRootPage = new RevisionRootPage(pageRtx.loadRevRoot(baseRevision), representRevision + 1);
        PageReference revisionRootPageReference = this.prepareLeafOfTree(pageRtx, log, uberPage.getPageCountExp(PageKind.UBERPAGE), uberPage.getIndirectPageReference(), uberPage.getRevisionNumber(), uberPage.getRevisionNumber(), -1, PageKind.UBERPAGE, revisionRootPage);
        log.put(revisionRootPageReference, PageContainer.getInstance(revisionRootPage, revisionRootPage));
        return revisionRootPage;
    }

    @Override
    public PageReference prepareLeafOfTree(PageReadOnlyTrx pageRtx, TransactionIntentLog log, int[] inpLevelPageCountExp, PageReference startReference, @Nonnegative long pageKey, @Nonnegative long maxPageKey, int index, PageKind pageKind, RevisionRootPage revisionRootPage) {
        PageReference reference = startReference;
        int offset = 0;
        long levelKey = pageKey;
        int maxHeight = pageRtx.getCurrentMaxIndirectPageTreeLevel(pageKind, index, revisionRootPage);
        if (pageKey == 1L << inpLevelPageCountExp[inpLevelPageCountExp.length - maxHeight - 1]) {
            maxHeight = this.incrementCurrentMaxIndirectPageTreeLevel(pageRtx, revisionRootPage, pageKind, index);
            IndirectPage oldPage = this.dereferenceOldIndirectPage(pageRtx, log, reference);
            IndirectPage page = new IndirectPage();
            PageReference newReference = page.getReference(0);
            log.put(newReference, PageContainer.getInstance(oldPage, oldPage));
            PageReference newPageReference = new PageReference();
            log.put(newPageReference, PageContainer.getInstance(page, page));
            this.setNewIndirectPage(pageRtx, revisionRootPage, pageKind, index, newPageReference);
            reference = newPageReference;
        }
        int height = inpLevelPageCountExp.length;
        for (int level = inpLevelPageCountExp.length - maxHeight; level < height; ++level) {
            offset = (int)(levelKey >> inpLevelPageCountExp[level]);
            levelKey -= (long)(offset << inpLevelPageCountExp[level]);
            IndirectPage page = this.prepareIndirectPage(pageRtx, log, reference);
            reference = page.getReference(offset);
        }
        return reference;
    }

    private IndirectPage dereferenceOldIndirectPage(PageReadOnlyTrx pageRtx, TransactionIntentLog log, PageReference reference) throws AssertionError {
        IndirectPage oldPage;
        PageContainer cont = log.get(reference, pageRtx);
        IndirectPage indirectPage = oldPage = cont == null ? null : (IndirectPage)cont.getComplete();
        if (oldPage == null) {
            if (reference.getKey() == -15L) {
                throw new AssertionError((Object)"The referenced page on top must of our tree must exist (first IndirectPage).");
            }
            IndirectPage indirectPage2 = pageRtx.dereferenceIndirectPageReference(reference);
            oldPage = new IndirectPage(indirectPage2);
        }
        return oldPage;
    }

    private void setNewIndirectPage(PageReadOnlyTrx pageRtx, RevisionRootPage revisionRoot, PageKind pageKind, int index, PageReference pageReference) {
        switch (pageKind) {
            case RECORDPAGE: {
                revisionRoot.setReference(0, pageReference);
                break;
            }
            case UBERPAGE: {
                pageRtx.getUberPage().setReference(0, pageReference);
                break;
            }
            case CASPAGE: {
                pageRtx.getCASPage(revisionRoot).setReference(index, pageReference);
                break;
            }
            case PATHPAGE: {
                pageRtx.getPathPage(revisionRoot).setReference(index, pageReference);
                break;
            }
            case NAMEPAGE: {
                pageRtx.getNamePage(revisionRoot).setReference(index, pageReference);
                break;
            }
            case PATHSUMMARYPAGE: {
                pageRtx.getPathSummaryPage(revisionRoot).setReference(index, pageReference);
                break;
            }
            default: {
                throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
            }
        }
    }

    private int incrementCurrentMaxIndirectPageTreeLevel(PageReadOnlyTrx pageRtx, RevisionRootPage revisionRoot, PageKind pageKind, int index) {
        switch (pageKind) {
            case RECORDPAGE: {
                return revisionRoot.incrementAndGetCurrentMaxLevelOfIndirectPages();
            }
            case CASPAGE: {
                return pageRtx.getCASPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            }
            case PATHPAGE: {
                return pageRtx.getPathPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            }
            case NAMEPAGE: {
                return pageRtx.getNamePage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            }
            case PATHSUMMARYPAGE: {
                return pageRtx.getPathSummaryPage(revisionRoot).incrementAndGetCurrentMaxLevelOfIndirectPages(index);
            }
        }
        throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
    }

    @Override
    public IndirectPage prepareIndirectPage(PageReadOnlyTrx pageRtx, TransactionIntentLog log, PageReference reference) {
        IndirectPage page;
        PageContainer cont = log.get(reference, pageRtx);
        IndirectPage indirectPage = page = cont == null ? null : (IndirectPage)cont.getComplete();
        if (page == null) {
            if (reference.getKey() == -15L) {
                page = new IndirectPage();
            } else {
                IndirectPage indirectPage2 = pageRtx.dereferenceIndirectPageReference(reference);
                page = new IndirectPage(indirectPage2);
            }
            log.put(reference, PageContainer.getInstance(page, page));
        }
        return page;
    }
}

