/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnegative;
import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.settings.Fixed;

public final class DescendantAxis
extends AbstractAxis {
    private Deque<Long> mRightSiblingKeyStack;
    private boolean mFirst;

    public DescendantAxis(NodeCursor cursor) {
        super(cursor);
    }

    public DescendantAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mFirst = true;
        this.mRightSiblingKeyStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        long key = Fixed.NULL_NODE_KEY.getStandardProperty();
        NodeCursor cursor = this.getCursor();
        if (this.mFirst) {
            this.mFirst = false;
            key = this.isSelfIncluded() == IncludeSelf.YES ? cursor.getNodeKey() : cursor.getFirstChildKey();
            return key;
        }
        if (cursor.hasFirstChild()) {
            key = cursor.getFirstChildKey();
            if (cursor.hasRightSibling()) {
                this.mRightSiblingKeyStack.push(cursor.getRightSiblingKey());
            }
            return key;
        }
        if (cursor.hasRightSibling()) {
            long currKey = cursor.getNodeKey();
            key = cursor.getRightSiblingKey();
            return this.hasNextNode(key, currKey);
        }
        if (this.mRightSiblingKeyStack.size() > 0) {
            long currKey = cursor.getNodeKey();
            key = this.mRightSiblingKeyStack.pop();
            return this.hasNextNode(key, currKey);
        }
        return this.done();
    }

    private long hasNextNode(@Nonnegative long key, @Nonnegative long currKey) {
        NodeCursor cursor = this.getCursor();
        cursor.moveTo(key);
        if (cursor.getLeftSiblingKey() == this.getStartKey()) {
            return this.done();
        }
        cursor.moveTo(currKey);
        return key;
    }
}

