/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.settings.Fixed;
import org.sirix.utils.Pair;

public final class JsonDescendantAxis
extends AbstractAxis {
    private Deque<Pair<Long, Integer>> mRightSiblingKeyStack;
    private boolean mFirst;
    private int mDepth;

    public JsonDescendantAxis(NodeCursor cursor) {
        super(cursor);
    }

    public JsonDescendantAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mFirst = true;
        this.mRightSiblingKeyStack = new ArrayDeque<Pair<Long, Integer>>();
    }

    @Override
    protected long nextKey() {
        long key = Fixed.NULL_NODE_KEY.getStandardProperty();
        NodeCursor cursor = this.getCursor();
        if (this.mFirst) {
            this.mFirst = false;
            if (this.isSelfIncluded() == IncludeSelf.YES) {
                key = cursor.getNodeKey();
            } else {
                key = cursor.getFirstChildKey();
                ++this.mDepth;
            }
            return key;
        }
        if (cursor.hasFirstChild()) {
            key = cursor.getFirstChildKey();
            if (cursor.hasRightSibling()) {
                this.mRightSiblingKeyStack.push(new Pair<Long, Integer>(cursor.getRightSiblingKey(), this.mDepth));
            }
            ++this.mDepth;
            return key;
        }
        if (cursor.hasRightSibling()) {
            key = cursor.getRightSiblingKey();
            if (this.mDepth == 0) {
                return this.done();
            }
            return key;
        }
        if (this.mRightSiblingKeyStack.size() > 0) {
            Pair<Long, Integer> pair = this.mRightSiblingKeyStack.pop();
            key = pair.getFirst();
            this.mDepth = pair.getSecond();
            if (this.mDepth == 0) {
                return this.done();
            }
            return key;
        }
        return this.done();
    }
}

