/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.concurrent.ConcurrentAxisHelper;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class ConcurrentAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(ConcurrentAxis.class));
    private final Axis mProducer;
    private final BlockingQueue<Long> mResults;
    private final int M_CAPACITY = 200;
    private boolean mFirst;
    private Runnable task;
    private boolean mFinished;
    public ExecutorService mExecutorService;

    public ConcurrentAxis(R rtx, Axis childAxis) {
        super((NodeCursor)rtx);
        if (((NodeReadOnlyTrx)rtx).getId() == childAxis.getTrx().getId()) {
            throw new IllegalArgumentException("The filter must be bound to another transaction but on the same revision/node!");
        }
        this.mResults = new ArrayBlockingQueue<Long>(200);
        this.mFirst = true;
        this.mProducer = (Axis)Preconditions.checkNotNull((Object)childAxis);
        this.task = new ConcurrentAxisHelper(this.mProducer, this.mResults);
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mFinished = false;
    }

    @Override
    public synchronized void reset(@Nonnegative long nodeKey) {
        super.reset(nodeKey);
        this.mFirst = true;
        this.mFinished = false;
        if (this.mExecutorService != null) {
            this.mExecutorService = Executors.newSingleThreadExecutor();
        }
        if (this.mProducer != null) {
            this.mProducer.reset(nodeKey);
        }
        if (this.mResults != null) {
            this.mResults.clear();
        }
        if (this.task != null) {
            this.task = new ConcurrentAxisHelper(this.mProducer, this.mResults);
        }
    }

    @Override
    protected long nextKey() {
        if (this.mFirst) {
            this.mFirst = false;
            this.mExecutorService.submit(this.task);
        }
        if (this.mFinished) {
            return this.done();
        }
        long result = Fixed.NULL_NODE_KEY.getStandardProperty();
        try {
            result = this.mResults.take();
        }
        catch (InterruptedException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        if (result != Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return result;
        }
        this.mFinished = true;
        return this.done();
    }

    @Override
    protected final long done() {
        this.mExecutorService.shutdown();
        try {
            this.mExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public boolean isFinished() {
        return this.mFinished;
    }
}

