/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.filter.json;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sirix.api.Filter;
import org.sirix.api.ResourceManager;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.axis.AbstractTemporalAxis;

public final class TemporalJsonNodeReadFilterAxis<F extends Filter<JsonNodeReadOnlyTrx>>
extends AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private final AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> mAxis;
    private final List<F> mAxisFilter;

    @SafeVarargs
    public TemporalJsonNodeReadFilterAxis(AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> axis, F firstAxisTest, F ... axisTest) {
        Preconditions.checkNotNull(firstAxisTest);
        this.mAxis = axis;
        this.mAxisFilter = new ArrayList<F>();
        this.mAxisFilter.add(firstAxisTest);
        if (axisTest != null) {
            int length = axisTest.length;
            for (int i = 0; i < length; ++i) {
                this.mAxisFilter.add(axisTest[i]);
            }
        }
    }

    protected JsonNodeReadOnlyTrx computeNext() {
        while (this.mAxis.hasNext()) {
            JsonNodeReadOnlyTrx rtx = (JsonNodeReadOnlyTrx)this.mAxis.next();
            boolean filterResult = this.doFilter(rtx);
            if (filterResult) {
                return rtx;
            }
            rtx.close();
        }
        return (JsonNodeReadOnlyTrx)this.endOfData();
    }

    private boolean doFilter(JsonNodeReadOnlyTrx rtx) {
        boolean filterResult = true;
        for (Filter filter : this.mAxisFilter) {
            filter.setTrx(rtx);
            if (filterResult = filterResult && filter.filter()) continue;
            break;
        }
        return filterResult;
    }

    public AbstractTemporalAxis<JsonNodeReadOnlyTrx, JsonNodeTrx> getAxis() {
        return this.mAxis;
    }

    @Override
    public ResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> getResourceManager() {
        return this.mAxis.getResourceManager();
    }
}

