/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.temporal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.AbstractTemporalAxis;

public final class AllTimeAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private int mRevision;
    private final ResourceManager<R, W> mResourceManager;
    private long mNodeKey;
    private boolean mHasMoved;

    public AllTimeAxis(ResourceManager<R, W> resourceManager, R rtx) {
        this.mResourceManager = (ResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mRevision = 1;
        this.mNodeKey = rtx.getNodeKey();
    }

    protected R computeNext() {
        while (this.mRevision <= this.mResourceManager.getMostRecentRevisionNumber()) {
            Optional<R> optionalRtx = this.mResourceManager.getNodeReadTrxByRevisionNumber(this.mRevision);
            NodeReadOnlyTrx rtx = optionalRtx.isPresent() ? (NodeReadOnlyTrx)optionalRtx.get() : this.mResourceManager.beginNodeReadOnlyTrx(this.mRevision);
            ++this.mRevision;
            if (rtx.moveTo(this.mNodeKey).hasMoved()) {
                this.mHasMoved = true;
                return (R)rtx;
            }
            if (!this.mHasMoved) continue;
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceManager<R, W> getResourceManager() {
        return this.mResourceManager;
    }
}

