/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.visitor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import org.sirix.access.trx.node.xml.AbstractXdmNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.axis.visitor.LocalVisitResult;
import org.sirix.diff.algorithm.fmse.Matching;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;
import org.sirix.node.immutable.xdm.ImmutableComment;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.immutable.xdm.ImmutablePI;
import org.sirix.node.immutable.xdm.ImmutableText;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public class DeleteFMSEVisitor
extends AbstractXdmNodeVisitor {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(DeleteFMSEVisitor.class));
    private final Matching mMatching;
    private final XmlNodeTrx mWtx;
    private final long mStartKey;

    public DeleteFMSEVisitor(XmlNodeTrx wtx, Matching matching, @Nonnegative long startKey) {
        this.mWtx = (XmlNodeTrx)Preconditions.checkNotNull((Object)wtx);
        this.mMatching = (Matching)Preconditions.checkNotNull((Object)matching);
        Preconditions.checkArgument((startKey >= 0L ? 1 : 0) != 0, (Object)"start key must be >= 0!");
        this.mStartKey = startKey;
    }

    @Override
    public VisitResult visit(ImmutableElement node) {
        int i;
        Long partner = this.mMatching.partner(node.getNodeKey());
        if (partner == null) {
            VisitResult retVal = this.delete(node);
            if (node.getNodeKey() == this.mStartKey) {
                retVal = VisitResultType.TERMINATE;
            }
            return retVal;
        }
        this.mWtx.moveTo(node.getNodeKey());
        long nodeKey = node.getNodeKey();
        ArrayList<Long> keysToDelete = new ArrayList<Long>(this.mWtx.getAttributeCount() + this.mWtx.getNamespaceCount());
        int attCount = this.mWtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.mWtx.moveToAttribute(i);
            long attNodeKey = this.mWtx.getNodeKey();
            if (this.mMatching.partner(attNodeKey) == null) {
                keysToDelete.add(attNodeKey);
            }
            this.mWtx.moveTo(nodeKey);
        }
        int nspCount = this.mWtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.mWtx.moveToNamespace(i);
            long namespNodeKey = this.mWtx.getNodeKey();
            if (this.mMatching.partner(namespNodeKey) == null) {
                keysToDelete.add(namespNodeKey);
            }
            this.mWtx.moveTo(nodeKey);
        }
        Iterator iterator = keysToDelete.iterator();
        while (iterator.hasNext()) {
            long keyToDelete = (Long)iterator.next();
            this.mWtx.moveTo(keyToDelete);
            try {
                this.mWtx.remove();
            }
            catch (SirixException e) {
                LOGWRAPPER.error(e.getMessage(), e);
            }
        }
        this.mWtx.moveTo(nodeKey);
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        return this.deleteLeaf(node);
    }

    @Override
    public VisitResult visit(ImmutableComment node) {
        return this.deleteLeaf(node);
    }

    @Override
    public VisitResult visit(ImmutablePI node) {
        return this.deleteLeaf(node);
    }

    private VisitResult deleteLeaf(ImmutableNode node) {
        Long partner = this.mMatching.partner(node.getNodeKey());
        if (partner == null) {
            VisitResult retVal = this.delete(node);
            if (node.getNodeKey() == this.mStartKey) {
                retVal = VisitResultType.TERMINATE;
            }
            return retVal;
        }
        return VisitResultType.CONTINUE;
    }

    private VisitResult delete(ImmutableNode node) {
        try {
            this.mWtx.moveTo(node.getNodeKey());
            long nodeKey = this.mWtx.getNodeKey();
            boolean removeTextNode = false;
            boolean resetValue = false;
            if (this.mWtx.hasLeftSibling() && this.mWtx.moveToLeftSibling().hasMoved() && this.mWtx.getKind() == Kind.TEXT && this.mWtx.moveToRightSibling().hasMoved() && this.mWtx.hasRightSibling() && this.mWtx.moveToRightSibling().hasMoved() && this.mWtx.getKind() == Kind.TEXT) {
                Long partner = this.mMatching.partner(this.mWtx.getNodeKey());
                if (partner == null) {
                    resetValue = true;
                }
                removeTextNode = true;
            }
            this.mWtx.moveTo(nodeKey);
            if (!removeTextNode) {
                boolean movedToParent = this.mWtx.moveToParent().hasMoved();
                assert (movedToParent);
                long parentNodeKey = this.mWtx.getNodeKey();
                if (this.mWtx.getChildCount() == 1L && this.mWtx.hasRightSibling()) {
                    this.mWtx.moveTo(nodeKey);
                    this.mWtx.remove();
                    assert (this.mWtx.getNodeKey() == parentNodeKey);
                    return LocalVisitResult.SKIPSUBTREEPOPSTACK;
                }
            }
            this.mWtx.moveTo(nodeKey);
            if (!this.mWtx.hasRightSibling() && this.mWtx.hasLeftSibling()) {
                long leftSiblKey = this.mWtx.getLeftSiblingKey();
                this.mWtx.remove();
                assert (this.mWtx.getNodeKey() == leftSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.mWtx.hasRightSibling() && this.mWtx.hasLeftSibling()) {
                long rightSiblKey = this.mWtx.getRightSiblingKey();
                long rightRightSiblKey = this.mWtx.moveToRightSibling().trx().getRightSiblingKey();
                this.mWtx.moveTo(nodeKey);
                String value = removeTextNode ? this.mWtx.moveToLeftSibling().trx().getValue() : "";
                this.mWtx.moveTo(nodeKey);
                this.mWtx.remove();
                if (removeTextNode) {
                    if (resetValue && !value.equals(this.mWtx.getValue())) {
                        this.mWtx.setValue(value);
                    }
                    assert (this.mWtx.getKind() == Kind.TEXT);
                    assert (this.mWtx.getRightSiblingKey() == rightRightSiblKey);
                    return VisitResultType.CONTINUE;
                }
                boolean moved = this.mWtx.moveToLeftSibling().hasMoved();
                assert (moved);
                assert (this.mWtx.getRightSiblingKey() == rightSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.mWtx.hasRightSibling() && !this.mWtx.hasLeftSibling()) {
                long rightSiblKey = this.mWtx.getRightSiblingKey();
                this.mWtx.remove();
                this.mWtx.moveToParent();
                assert (this.mWtx.getFirstChildKey() == rightSiblKey);
                return VisitResultType.CONTINUE;
            }
            long parentKey = this.mWtx.getParentKey();
            this.mWtx.remove();
            assert (this.mWtx.getNodeKey() == parentKey);
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }
}

