/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.visitor;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.xml.AbstractXdmNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.axis.visitor.LocalVisitResult;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.immutable.xdm.ImmutableText;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.service.xml.shredder.XmlShredder;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class ModificationVisitor
extends AbstractXdmNodeVisitor {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(ModificationVisitor.class));
    private static final int MODIFY_EVERY = 1111;
    private final XmlNodeTrx mWtx;
    private final Random mRandom = new Random();
    private final long mStartKey;
    private long mNodeIndex;

    public ModificationVisitor(XmlNodeTrx wtx, long startKey) {
        this.mWtx = (XmlNodeTrx)Preconditions.checkNotNull((Object)wtx);
        Preconditions.checkArgument((startKey >= 0L ? 1 : 0) != 0, (Object)"start key must be >= 0!");
        this.mStartKey = startKey;
        this.mNodeIndex = 1L;
    }

    @Override
    public VisitResult visit(ImmutableElement node) {
        return this.processNode(node);
    }

    private VisitResult processNode(ImmutableNode node) {
        assert (node != null);
        VisitResult result = this.modify(node);
        if (node.getNodeKey() == this.mStartKey) {
            return VisitResultType.TERMINATE;
        }
        return result;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        return this.processNode(node);
    }

    private VisitResult modify(ImmutableNode node) {
        assert (node != null);
        if (this.mNodeIndex % 1111L == 0L) {
            this.mNodeIndex = 1L;
            try {
                switch (this.mRandom.nextInt(4)) {
                    case 0: {
                        QNm insert = new QNm("testInsert");
                        long key = this.mWtx.getNodeKey();
                        this.mWtx.insertElementAsLeftSibling(insert);
                        boolean moved = this.mWtx.moveTo(key).hasMoved();
                        assert (moved);
                        return VisitResultType.CONTINUE;
                    }
                    case 1: {
                        if (this.mWtx.getKind() == Kind.TEXT) {
                            this.mWtx.setValue("testUpdate");
                        } else if (this.mWtx.getKind() == Kind.ELEMENT) {
                            this.mWtx.setName(new QNm("testUpdate"));
                        }
                        return VisitResultType.CONTINUE;
                    }
                    case 2: {
                        return this.delete();
                    }
                    case 3: {
                        this.mWtx.replaceNode(XmlShredder.createStringReader("<foo/>"));
                        return VisitResultType.CONTINUE;
                    }
                }
            }
            catch (SirixException e) {
                LOGWRAPPER.error(e.getMessage(), e);
                return VisitResultType.TERMINATE;
            }
        } else {
            ++this.mNodeIndex;
            return VisitResultType.CONTINUE;
        }
        return VisitResultType.CONTINUE;
    }

    private VisitResult delete() throws SirixException {
        try {
            long nodeKey = this.mWtx.getNodeKey();
            boolean removeTextNode = false;
            if (this.mWtx.getLeftSiblingKind() == Kind.TEXT && this.mWtx.getRightSiblingKind() == Kind.TEXT) {
                removeTextNode = true;
            }
            this.mWtx.moveTo(nodeKey);
            if (!removeTextNode) {
                boolean movedToParent = this.mWtx.moveToParent().hasMoved();
                assert (movedToParent);
                long parentNodeKey = this.mWtx.getNodeKey();
                if (this.mWtx.getChildCount() == 1L && this.mWtx.hasRightSibling()) {
                    this.mWtx.moveTo(nodeKey);
                    this.mWtx.remove();
                    assert (this.mWtx.getNodeKey() == parentNodeKey);
                    return LocalVisitResult.SKIPSUBTREEPOPSTACK;
                }
            }
            this.mWtx.moveTo(nodeKey);
            if (!this.mWtx.hasRightSibling() && this.mWtx.hasLeftSibling()) {
                long leftSiblKey = this.mWtx.getLeftSiblingKey();
                this.mWtx.remove();
                assert (this.mWtx.getNodeKey() == leftSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.mWtx.hasRightSibling() && this.mWtx.hasLeftSibling()) {
                long rightSiblKey = this.mWtx.getRightSiblingKey();
                long rightRightSiblKey = this.mWtx.moveToRightSibling().trx().getRightSiblingKey();
                this.mWtx.moveTo(nodeKey);
                this.mWtx.remove();
                if (removeTextNode) {
                    assert (this.mWtx.getKind() == Kind.TEXT);
                    assert (this.mWtx.getRightSiblingKey() == rightRightSiblKey);
                    return VisitResultType.CONTINUE;
                }
                boolean moved = this.mWtx.moveToLeftSibling().hasMoved();
                assert (moved);
                assert (this.mWtx.getRightSiblingKey() == rightSiblKey);
                return VisitResultType.SKIPSUBTREE;
            }
            if (this.mWtx.hasRightSibling() && !this.mWtx.hasLeftSibling()) {
                long rightSiblKey = this.mWtx.getRightSiblingKey();
                this.mWtx.remove();
                this.mWtx.moveToParent();
                assert (this.mWtx.getFirstChildKey() == rightSiblKey);
                return VisitResultType.CONTINUE;
            }
            long parentKey = this.mWtx.getParentKey();
            this.mWtx.remove();
            assert (this.mWtx.getNodeKey() == parentKey);
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }
}

