/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.sirix.page.interfaces.Page;

public final class PageContainer {
    private final Page mComplete;
    private final Page mModified;
    private static final PageContainer EMPTY_INSTANCE = new PageContainer(null, null);

    public static final PageContainer emptyInstance() {
        return EMPTY_INSTANCE;
    }

    public static final PageContainer getInstance(Page complete, Page modifying) {
        assert (complete != null);
        assert (modifying != null);
        return new PageContainer(complete, modifying);
    }

    private PageContainer(Page complete, Page modifying) {
        this.mComplete = complete;
        this.mModified = modifying;
    }

    public Page getComplete() {
        return this.mComplete;
    }

    public Page getModified() {
        return this.mModified;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mComplete, this.mModified});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PageContainer)) {
            return false;
        }
        PageContainer other = (PageContainer)obj;
        return Objects.equal((Object)this.mComplete, (Object)other.mComplete) && Objects.equal((Object)this.mModified, (Object)other.mModified);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("complete page", (Object)this.mComplete).add("modified page", (Object)this.mModified).toString();
    }
}

