/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import org.sirix.diff.DiffDepth;
import org.sirix.diff.DiffFactory;

public final class DiffTuple
implements Serializable {
    private static final long serialVersionUID = -8805161170968505227L;
    private DiffFactory.DiffType mDiff;
    private final long mNewNodeKey;
    private final long mOldNodeKey;
    private final DiffDepth mDepth;
    private int mIndex;

    public DiffTuple(DiffFactory.DiffType diff, long newNodeKey, long oldNodeKey, DiffDepth depth) {
        Preconditions.checkArgument((newNodeKey >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((oldNodeKey >= 0L ? 1 : 0) != 0);
        this.mDiff = (DiffFactory.DiffType)((Object)Preconditions.checkNotNull((Object)((Object)diff)));
        this.mNewNodeKey = newNodeKey;
        this.mOldNodeKey = oldNodeKey;
        this.mDepth = (DiffDepth)Preconditions.checkNotNull((Object)depth);
    }

    public DiffFactory.DiffType getDiff() {
        return this.mDiff;
    }

    public DiffTuple setDiff(DiffFactory.DiffType diffType) {
        this.mDiff = (DiffFactory.DiffType)((Object)Preconditions.checkNotNull((Object)((Object)diffType)));
        return this;
    }

    public DiffTuple setIndex(@Nonnegative int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        this.mIndex = index;
        return this;
    }

    public long getNewNodeKey() {
        return this.mNewNodeKey;
    }

    public long getOldNodeKey() {
        return this.mOldNodeKey;
    }

    public DiffDepth getDepth() {
        return this.mDepth;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("diff", (Object)this.mDiff).add("new nodeKey", this.mNewNodeKey).add("old nodeKey", this.mOldNodeKey).toString();
    }

    public int getIndex() {
        return this.mIndex;
    }
}

