/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sirix.access.trx.node.xml.AbstractXdmNodeVisitor;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.node.Kind;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.immutable.xdm.ImmutableText;

public final class LabelFMSEVisitor
extends AbstractXdmNodeVisitor {
    private final XmlNodeReadOnlyTrx mRtx;
    private final Map<Kind, List<Long>> mLabels;
    private final Map<Kind, List<Long>> mLeafLabels;

    public LabelFMSEVisitor(XmlNodeReadOnlyTrx readTrx) {
        this.mRtx = (XmlNodeReadOnlyTrx)Preconditions.checkNotNull((Object)readTrx);
        this.mLabels = new HashMap<Kind, List<Long>>();
        this.mLeafLabels = new HashMap<Kind, List<Long>>();
    }

    @Override
    public VisitResultType visit(ImmutableElement node) {
        int i;
        long nodeKey = node.getNodeKey();
        this.mRtx.moveTo(nodeKey);
        int nspCount = this.mRtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.mRtx.moveToNamespace(i);
            this.addLeafLabel();
            this.mRtx.moveTo(nodeKey);
        }
        int attCount = this.mRtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.mRtx.moveToAttribute(i);
            this.addLeafLabel();
            this.mRtx.moveTo(nodeKey);
        }
        if (!this.mLabels.containsKey(node.getKind())) {
            this.mLabels.put(node.getKind(), new ArrayList());
        }
        this.mLabels.get(node.getKind()).add(node.getNodeKey());
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResultType visit(ImmutableText node) {
        this.mRtx.moveTo(node.getNodeKey());
        this.addLeafLabel();
        return VisitResultType.CONTINUE;
    }

    private void addLeafLabel() {
        Kind nodeKind = this.mRtx.getKind();
        if (!this.mLeafLabels.containsKey(nodeKind)) {
            this.mLeafLabels.put(nodeKind, new ArrayList());
        }
        this.mLeafLabels.get(nodeKind).add(this.mRtx.getNodeKey());
    }

    public Map<Kind, List<Long>> getLabels() {
        return this.mLabels;
    }

    public Map<Kind, List<Long>> getLeafLabels() {
        return this.mLeafLabels;
    }
}

