/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.sirix.diff.algorithm.fmse.NodeComparator;
import org.sirix.utils.Pair;

public final class Util {
    private Util() {
        throw new AssertionError((Object)"May not be instantiated!");
    }

    public static <T> List<Pair<T, T>> longestCommonSubsequence(@Nonnull List<T> first, @Nonnull List<T> second, @Nonnull NodeComparator<T> cmp) {
        int i;
        if (first == null || second == null) {
            return new ArrayList<Pair<T, T>>();
        }
        if (first.size() == 0 && second.size() == 0) {
            return new ArrayList<Pair<T, T>>();
        }
        List x = (List)Preconditions.checkNotNull(first);
        List y = (List)Preconditions.checkNotNull(second);
        int n = x.size();
        int m = y.size();
        int max = n + m;
        int[] v = new int[2 * max + 1];
        ArrayList common = new ArrayList(2 * max + 1);
        for (i = 0; i <= 2 * max; ++i) {
            v[i] = 0;
            common.add(i, new ArrayList());
        }
        for (i = 0; i <= max; ++i) {
            for (int j = -i; j <= i; j += 2) {
                int idxY;
                int idxX;
                if (j == -i || j != i && v[max + j - 1] < v[max + j + 1]) {
                    idxX = v[max + j + 1];
                    common.set(max + j, new ArrayList((Collection)common.get(max + j + 1)));
                } else {
                    idxX = v[max + j - 1] + 1;
                    common.set(max + j, new ArrayList((Collection)common.get(max + j - 1)));
                }
                for (idxY = idxX - j; idxX < n && idxY < m && cmp.isEqual(x.get(idxX), y.get(idxY)); ++idxX, ++idxY) {
                    ((List)common.get(max + j)).add(new Pair(x.get(idxX), y.get(idxY)));
                }
                v[max + j] = idxX;
                if (idxX < n || idxY < m) continue;
                return (List)common.get(max + j);
            }
        }
        throw new IllegalStateException("We should never get to this point!");
    }

    public static float quickRatio(String first, String second) {
        if (first.isEmpty() && second.isEmpty() || first.equals(second)) {
            return 1.0f;
        }
        float matches = 0.0f;
        int[][] x = new int[256][];
        for (char c : second.toCharArray()) {
            if (x[c >> 8] == null) {
                x[c >> 8] = new int[256];
            }
            int[] nArray = x[c >> 8];
            int n = c & 0xFF;
            nArray[n] = nArray[n] + 1;
        }
        for (char c : first.toCharArray()) {
            int n;
            if (x[c >> 8] == null) {
                n = 0;
            } else {
                int[] nArray = x[c >> 8];
                int n2 = c & 0xFF;
                int n3 = nArray[n2];
                n = n3;
                nArray[n2] = n3 - 1;
            }
            int n4 = n;
            if (n4 <= 0) continue;
            matches += 1.0f;
        }
        return (float)(2.0 * (double)matches / (double)(first.length() + second.length()));
    }
}

