/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.avltree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.index.avltree.interfaces.MutableAVLNode;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.settings.Fixed;

public final class AVLNode<K extends Comparable<? super K>, V>
extends AbstractForwardingNode
implements MutableAVLNode<K, V> {
    private K mKey;
    private V mValue;
    private long mLeft = Fixed.NULL_NODE_KEY.getStandardProperty();
    private long mRight = Fixed.NULL_NODE_KEY.getStandardProperty();
    private boolean mChanged;
    private NodeDelegate mNodeDelegate;

    public AVLNode(K key, V value, NodeDelegate delegate) {
        this.mKey = (Comparable)Preconditions.checkNotNull(key);
        this.mValue = Preconditions.checkNotNull(value);
        this.mNodeDelegate = (NodeDelegate)Preconditions.checkNotNull((Object)delegate);
    }

    @Override
    public Kind getKind() {
        if (this.mKey instanceof Long) {
            return Kind.PATHAVL;
        }
        if (this.mKey instanceof CASValue) {
            return Kind.CASAVL;
        }
        if (this.mKey instanceof QNm) {
            return Kind.NAMEAVL;
        }
        return Kind.UNKNOWN;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mNodeDelegate;
    }

    @Override
    public K getKey() {
        return this.mKey;
    }

    @Override
    public V getValue() {
        return this.mValue;
    }

    @Override
    public boolean isChanged() {
        return this.mChanged;
    }

    @Override
    public void setChanged(boolean changed) {
        this.mChanged = changed;
    }

    @Override
    public boolean hasLeftChild() {
        return this.mLeft != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasRightChild() {
        return this.mRight != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getLeftChildKey() {
        return this.mLeft;
    }

    @Override
    public long getRightChildKey() {
        return this.mRight;
    }

    @Override
    public void setLeftChildKey(long left) {
        this.mLeft = left;
    }

    @Override
    public void setRightChildKey(long right) {
        this.mRight = right;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeDelegate.getNodeKey()});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AVLNode) {
            AVLNode other = (AVLNode)obj;
            return this.mNodeDelegate.getNodeKey() == other.mNodeDelegate.getNodeKey();
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.mNodeDelegate).add("left child", this.mLeft).add("right child", this.mRight).add("changed", this.mChanged).add("key", this.mKey).add("value", this.mValue).toString();
    }

    @Override
    public void setKey(K key) {
        this.mKey = (Comparable)Preconditions.checkNotNull(key);
    }

    @Override
    public void setValue(V value) {
        this.mValue = Preconditions.checkNotNull(value);
    }
}

