/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.avltree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.access.trx.node.AbstractForwardingNodeCursor;
import org.sirix.api.NodeCursor;
import org.sirix.api.PageTrx;
import org.sirix.cache.PageContainer;
import org.sirix.exception.SirixIOException;
import org.sirix.index.IndexType;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.interfaces.References;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.xdm.AbstractStructForwardingNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.page.CASPage;
import org.sirix.page.NamePage;
import org.sirix.page.PageReference;
import org.sirix.page.PathPage;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class AVLTreeWriter<K extends Comparable<? super K>, V extends References>
extends AbstractForwardingNodeCursor {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(AVLTreeWriter.class));
    private final AVLTreeReader<K, V> mAVLTreeReader;
    private final PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;

    private AVLTreeWriter(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexType type, @Nonnegative int index) {
        try {
            RevisionRootPage revisionRootPage = pageWriteTrx.getActualRevisionRootPage();
            switch (type) {
                case PATH: {
                    PathPage pathPage = pageWriteTrx.getPathPage(revisionRootPage);
                    PageReference reference = revisionRootPage.getPathPageReference();
                    pageWriteTrx.appendLogRecord(reference, PageContainer.getInstance(pathPage, pathPage));
                    pathPage.createPathIndexTree(pageWriteTrx, index, pageWriteTrx.getLog());
                    break;
                }
                case CAS: {
                    CASPage casPage = pageWriteTrx.getCASPage(revisionRootPage);
                    PageReference reference = revisionRootPage.getCASPageReference();
                    pageWriteTrx.appendLogRecord(reference, PageContainer.getInstance(casPage, casPage));
                    casPage.createCASIndexTree(pageWriteTrx, index, pageWriteTrx.getLog());
                    break;
                }
                case NAME: {
                    NamePage namePage = pageWriteTrx.getNamePage(revisionRootPage);
                    PageReference reference = revisionRootPage.getNamePageReference();
                    pageWriteTrx.appendLogRecord(reference, PageContainer.getInstance(namePage, namePage));
                    namePage.createNameIndexTree(pageWriteTrx, index, pageWriteTrx.getLog());
                    break;
                }
            }
        }
        catch (SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        this.mAVLTreeReader = AVLTreeReader.getInstance(pageWriteTrx, type, index);
        this.mPageWriteTrx = pageWriteTrx;
    }

    public static <K extends Comparable<? super K>, V extends References> AVLTreeWriter<K, V> getInstance(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexType type, int index) {
        return new AVLTreeWriter<K, V>(pageWriteTrx, type, index);
    }

    public V index(K key, V value, AVLTreeReader.MoveCursor move) throws SirixIOException {
        int c;
        if (move == AVLTreeReader.MoveCursor.TO_DOCUMENT_ROOT) {
            this.moveToDocumentRoot();
        }
        RevisionRootPage root = this.mPageWriteTrx.getActualRevisionRootPage();
        if (this.mAVLTreeReader.getAVLNode() == null && ((XdmDocumentRootNode)this.getNode()).getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            long nodeKey = this.getNewNodeKey(root);
            AVLNode<K, V> treeRoot = this.mPageWriteTrx.createEntry(nodeKey, new AVLNode<K, V>(key, value, new NodeDelegate(nodeKey, Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), 0L, 0L, null)), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            XdmDocumentRootNode document = (XdmDocumentRootNode)this.mPageWriteTrx.prepareEntryForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            document.setFirstChildKey(treeRoot.getNodeKey());
            document.incrementChildCount();
            document.incrementDescendantCount();
            return value;
        }
        if (move == AVLTreeReader.MoveCursor.TO_DOCUMENT_ROOT || this.mAVLTreeReader.getAVLNode() == null) {
            this.moveToDocumentRoot();
            this.moveToFirstChild();
        }
        AVLNode node = this.mAVLTreeReader.getAVLNode();
        while (true) {
            boolean moved;
            if ((c = key.compareTo(node.getKey())) == 0) {
                if (!value.equals(node.getValue())) {
                    AVLNode avlNode = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
                    avlNode.setValue(value);
                }
                return (V)((References)node.getValue());
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.mAVLTreeReader.getAVLNode();
        }
        long nodeKey = this.getNewNodeKey(root);
        AVLNode<K, V> child = this.mPageWriteTrx.createEntry(nodeKey, new AVLNode<K, V>(key, value, new NodeDelegate(nodeKey, node.getNodeKey(), 0L, 0L, null)), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        if (c < 0) {
            node.setLeftChildKey(child.getNodeKey());
            this.adjust(child);
        } else {
            node.setRightChildKey(child.getNodeKey());
            this.adjust(child);
        }
        XdmDocumentRootNode document = (XdmDocumentRootNode)this.mPageWriteTrx.prepareEntryForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        document.incrementDescendantCount();
        return value;
    }

    private long getNewNodeKey(RevisionRootPage root) throws SirixIOException {
        switch (this.mAVLTreeReader.mPageKind) {
            case PATHPAGE: {
                return this.mPageWriteTrx.getPathPage(root).getMaxNodeKey(this.mAVLTreeReader.mIndex) + 1L;
            }
            case CASPAGE: {
                return this.mPageWriteTrx.getCASPage(root).getMaxNodeKey(this.mAVLTreeReader.mIndex) + 1L;
            }
            case NAMEPAGE: {
                return this.mPageWriteTrx.getNamePage(root).getMaxNodeKey(this.mAVLTreeReader.mIndex) + 1L;
            }
            case PATHSUMMARYPAGE: {
                return this.mPageWriteTrx.getPathSummaryPage(root).getMaxNodeKey(this.mAVLTreeReader.mIndex) + 1L;
            }
        }
        throw new IllegalStateException();
    }

    public boolean remove(K key, @Nonnegative long nodeKey) throws SirixIOException {
        Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
        Optional<V> searchedValue = this.mAVLTreeReader.get((Comparable)Preconditions.checkNotNull(key), SearchMode.EQUAL);
        boolean removed = false;
        if (searchedValue.isPresent()) {
            References value = (References)searchedValue.get();
            removed = value.removeNodeKey(nodeKey);
        }
        return removed;
    }

    private void adjust(AVLNode<K, V> node) throws SirixIOException {
        this.setChanged(node, true);
        while (node != null && node.getParentKey() != Fixed.DOCUMENT_NODE_KEY.getStandardProperty() && this.parent(node) != null && this.parent(node).isChanged()) {
            AVLNode<K, V> y;
            if (this.parent(node).equals(this.left(this.parent(this.parent(node))))) {
                y = this.right(this.parent(this.parent(node)));
                if (y != null && y.isChanged()) {
                    this.setChanged(this.parent(node), false);
                    y.setChanged(false);
                    this.setChanged(this.parent(this.parent(node)), true);
                    node = this.parent(this.parent(node));
                    continue;
                }
                if (node.equals(this.right(this.parent(node)))) {
                    node = this.parent(node);
                    this.rotateLeft(node);
                }
                this.setChanged(this.parent(node), false);
                this.setChanged(this.parent(this.parent(node)), true);
                if (this.parent(this.parent(node)) == null) continue;
                this.rotateRight(this.parent(this.parent(node)));
                continue;
            }
            if (this.parent(node).equals(this.right(this.parent(this.parent(node))))) {
                y = this.left(this.parent(this.parent(node)));
                if (y != null && y.isChanged()) {
                    this.setChanged(this.parent(node), false);
                    this.setChanged(y, false);
                    this.setChanged(this.parent(this.parent(node)), true);
                    node = this.parent(this.parent(node));
                    continue;
                }
                if (node.equals(this.left(this.parent(node)))) {
                    node = this.parent(node);
                    this.rotateRight(node);
                }
                this.setChanged(this.parent(node), false);
                this.setChanged(this.parent(this.parent(node)), true);
                if (this.parent(this.parent(node)) == null) continue;
                this.rotateLeft(this.parent(this.parent(node)));
                continue;
            }
            node = null;
        }
        long nodeKey = this.getNodeKey();
        this.moveToDocumentRoot();
        if (((XdmDocumentRootNode)this.getNode()).hasFirstChild()) {
            this.moveToFirstChild();
            this.setChanged(this.mAVLTreeReader.getAVLNode(), false);
        }
        this.moveTo(nodeKey);
    }

    private void setChanged(AVLNode<K, V> nodeToChange, boolean changed) throws SirixIOException {
        AVLNode node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(nodeToChange.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node.setChanged(changed);
    }

    private AVLNode<K, V> left(@Nullable AVLNode<K, V> node) {
        if (node == null || node.getLeftChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        return this.moveTo(node.getLeftChildKey()).hasMoved() ? this.mAVLTreeReader.getAVLNode() : null;
    }

    private AVLNode<K, V> right(@Nullable AVLNode<K, V> node) {
        if (node == null || node.getRightChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        return this.moveTo(node.getRightChildKey()).hasMoved() ? this.mAVLTreeReader.getAVLNode() : null;
    }

    private AVLNode<K, V> parent(@Nullable AVLNode<K, V> node) {
        if (node == null || node.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        return this.moveTo(node.getParentKey()).hasMoved() ? this.mAVLTreeReader.getAVLNode() : null;
    }

    private void rotateLeft(AVLNode<K, V> node) throws SirixIOException {
        AbstractForwardingNode parent;
        this.moveTo(node.getNodeKey());
        AVLNode right = ((AVLTreeReader)this.moveToLastChild().trx()).getAVLNode();
        node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node.setRightChildKey(right.getLeftChildKey());
        if (right.hasLeftChild()) {
            AVLNode rightLeftChild = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(right.getLeftChildKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            rightLeftChild.setParentKey(node.getNodeKey());
        }
        right = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(right.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        right.setParentKey(node.getParentKey());
        if (node.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            parent = (XdmDocumentRootNode)this.mPageWriteTrx.prepareEntryForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AbstractStructForwardingNode)parent).setFirstChildKey(right.getNodeKey());
        } else if (this.moveTo(node.getParentKey()).hasMoved() && this.mAVLTreeReader.getAVLNode().getLeftChildKey() == node.getNodeKey()) {
            parent = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(this.mAVLTreeReader.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AVLNode)parent).setLeftChildKey(right.getNodeKey());
        } else {
            parent = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(this.mAVLTreeReader.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AVLNode)parent).setRightChildKey(right.getNodeKey());
        }
        right = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(right.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        right.setLeftChildKey(node.getNodeKey());
        node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node.setParentKey(right.getNodeKey());
    }

    private void rotateRight(AVLNode<K, V> node) throws SirixIOException {
        AbstractForwardingNode parent;
        this.moveTo(node.getNodeKey());
        AVLNode leftChild = ((AVLTreeReader)this.moveToFirstChild().trx()).getAVLNode();
        node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node.setLeftChildKey(leftChild.getRightChildKey());
        if (leftChild.hasRightChild()) {
            Node leftRightChild = (Node)this.mPageWriteTrx.prepareEntryForModification(leftChild.getRightChildKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            leftRightChild.setParentKey(node.getNodeKey());
        }
        leftChild = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(leftChild.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        leftChild.setParentKey(node.getParentKey());
        if (node.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            parent = (XdmDocumentRootNode)this.mPageWriteTrx.prepareEntryForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AbstractStructForwardingNode)parent).setFirstChildKey(leftChild.getNodeKey());
        } else if (this.moveTo(node.getParentKey()).hasMoved() && this.mAVLTreeReader.getAVLNode().getRightChildKey() == node.getNodeKey()) {
            parent = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(this.mAVLTreeReader.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AVLNode)parent).setRightChildKey(leftChild.getNodeKey());
        } else {
            parent = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(this.mAVLTreeReader.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
            ((AVLNode)parent).setLeftChildKey(leftChild.getNodeKey());
        }
        leftChild = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(leftChild.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        leftChild.setRightChildKey(node.getNodeKey());
        node = (AVLNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), this.mAVLTreeReader.mPageKind, this.mAVLTreeReader.mIndex);
        node.setParentKey(leftChild.getNodeKey());
    }

    @Override
    public void close() {
        this.mAVLTreeReader.close();
    }

    @Override
    protected NodeCursor delegate() {
        return this.mAVLTreeReader;
    }

    public Optional<V> get(K key, SearchMode mode) {
        return this.mAVLTreeReader.get((Comparable)Preconditions.checkNotNull(key), (SearchMode)((Object)Preconditions.checkNotNull((Object)((Object)mode))));
    }

    public AVLTreeReader<K, V> getReader() {
        return this.mAVLTreeReader;
    }
}

