/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.avltree.keyvalue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.xdm.Type;
import org.sirix.exception.SirixException;
import org.sirix.index.AtomicUtil;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class CASValue
implements Comparable<CASValue> {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(CASValue.class));
    private final Atomic mValue;
    private final long mPathNodeKey;
    private final Type mType;

    public CASValue(Atomic value, Type type, @Nonnegative long pathNodeKey) {
        this.mValue = (Atomic)Preconditions.checkNotNull((Object)value);
        this.mType = (Type)Preconditions.checkNotNull((Object)type);
        this.mType.atomicCode();
        this.mPathNodeKey = pathNodeKey;
    }

    public byte[] getValue() {
        byte[] retVal = new byte[1];
        try {
            retVal = AtomicUtil.toBytes(this.mValue, this.mType);
        }
        catch (SirixException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return retVal;
    }

    public Atomic getAtomicValue() {
        try {
            return this.mValue.asType(this.mType);
        }
        catch (QueryException e) {
            LOGGER.error(e.getMessage(), new Object[]{e});
            return null;
        }
    }

    @Override
    public int compareTo(@Nullable CASValue other) {
        CASValue otherValue = other;
        Atomic thisAtomic = null;
        Atomic otherAtomic = null;
        try {
            thisAtomic = this.mValue.asType(this.mType);
            otherAtomic = otherValue.mValue.asType(otherValue.mType);
        }
        catch (QueryException e) {
            LOGGER.error(e.getMessage(), new Object[]{e});
        }
        return ComparisonChain.start().compare(this.mPathNodeKey, otherValue.mPathNodeKey).compare((Comparable)thisAtomic, (Comparable)otherAtomic).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mValue, this.mType, this.mPathNodeKey});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof CASValue) {
            CASValue otherValue = (CASValue)obj;
            return Objects.equal((Object)otherValue.mValue, (Object)this.mValue) && Objects.equal((Object)otherValue.mType, (Object)this.mType) && otherValue.mPathNodeKey == this.mPathNodeKey;
        }
        return false;
    }

    public long getPathNodeKey() {
        return this.mPathNodeKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.mValue).add("pathNodeKey", this.mPathNodeKey).toString();
    }

    public Type getType() {
        return this.mType;
    }
}

