/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.bplustree;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.index.bplustree.VoidValue;
import org.sirix.node.interfaces.Record;
import org.sirix.page.AbstractForwardingPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.SerializationType;
import org.sirix.page.delegates.PageDelegate;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;

public class BPlusInnerNodePage<K extends Comparable<? super K> & Record, V extends Record>
extends AbstractForwardingPage
implements KeyValuePage<K, V> {
    private final long mRecordPageKey;
    private final Map<K, V> mRecords;
    private final PageReadOnlyTrx mPageReadTrx;
    private Optional<PageReference> mLeftPage;
    private Optional<PageReference> mRightPage;
    private final PageDelegate mDelegate;
    private final PageKind mPageKind;

    public BPlusInnerNodePage(@Nonnegative long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        assert (recordPageKey >= 0L) : "recordPageKey must not be negative!";
        assert (pageKind != null);
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.mRecordPageKey = recordPageKey;
        this.mRecords = new TreeMap();
        this.mPageReadTrx = pageReadTrx;
        this.mDelegate = new PageDelegate(512);
        this.mPageKind = pageKind;
    }

    protected BPlusInnerNodePage(ByteArrayDataInput in, PageReadOnlyTrx pageReadTrx) {
        this.mDelegate = null;
        this.mRecordPageKey = in.readLong();
        int size = in.readInt();
        this.mRecords = new TreeMap();
        pageReadTrx.getResourceManager().getResourceConfig();
        for (int offset = 0; offset < size; ++offset) {
            new VoidValue();
        }
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.mPageReadTrx = pageReadTrx;
        this.mPageKind = PageKind.getKind(in.readByte());
    }

    public void setLeftPage(Optional<PageReference> leftPage) {
        this.mLeftPage = leftPage;
    }

    public void setRightPage(Optional<PageReference> rightPage) {
        this.mLeftPage = rightPage;
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        super.serialize(out, type);
        out.writeLong(this.mRecordPageKey);
        out.writeInt(this.mRecords.size());
        this.serializePointer(this.mLeftPage, out);
        this.serializePointer(this.mRightPage, out);
        this.mPageReadTrx.getResourceManager().getResourceConfig();
        out.writeByte(this.mPageKind.getID());
    }

    private void serializePointer(Optional<PageReference> page, DataOutput out) throws IOException {
        if (page.isPresent()) {
            out.writeBoolean(page.get().getKey() != -15L);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mRecords.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.mRecords.values();
    }

    @Override
    public long getPageKey() {
        return this.mRecordPageKey;
    }

    @Override
    public V getValue(K key) {
        return (V)((Record)this.mRecords.get(key));
    }

    @Override
    public void setEntry(K key, @Nullable V value) {
        this.mRecords.put(key, value);
    }

    @Override
    public <C extends KeyValuePage<K, V>> C newInstance(@Nonnegative long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        return (C)new BPlusInnerNodePage<K, V>(recordPageKey, pageKind, previousPageRefKey, pageReadTrx);
    }

    @Override
    public PageReadOnlyTrx getPageReadTrx() {
        return this.mPageReadTrx;
    }

    @Override
    protected Page delegate() {
        return this.mDelegate;
    }

    @Override
    public PageKind getPageKind() {
        return this.mPageKind;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Set<Map.Entry<K, PageReference>> referenceEntrySet() {
        return null;
    }

    @Override
    public void setPageReference(K key, PageReference reference) {
    }

    @Override
    public PageReference getPageReference(K key) {
        return null;
    }

    @Override
    public long getPreviousReferenceKey() {
        return -1L;
    }

    public static enum Kind {
        LEAF,
        INNERNODE;

    }
}

