/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.sirix.index.Filter;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PathFilter;

public final class CASFilterRange
implements Filter {
    private final Set<Path<QNm>> mPaths;
    private final PathFilter mPathFilter;
    private final Atomic mMin;
    private final Atomic mMax;
    private final boolean mIncMin;
    private final boolean mIncMax;

    public CASFilterRange(Set<Path<QNm>> paths, Atomic min, Atomic max, boolean incMin, boolean incMax, PCRCollector pcrCollector) {
        this.mPaths = (Set)Preconditions.checkNotNull(paths);
        this.mPathFilter = new PathFilter(this.mPaths, pcrCollector);
        this.mMin = (Atomic)Preconditions.checkNotNull((Object)min);
        this.mMax = (Atomic)Preconditions.checkNotNull((Object)max);
        this.mIncMin = incMin;
        this.mIncMax = incMax;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(AVLNode<K, NodeReferences> node) {
        K key = node.getKey();
        if (key instanceof CASValue) {
            CASValue casValue = (CASValue)key;
            boolean filtered = this.mPathFilter.filter(node);
            if (filtered) {
                return this.inRange(casValue.getAtomicValue());
            }
        }
        return false;
    }

    private <K extends Comparable<? super K>> boolean inRange(Atomic key) {
        int minKeyCompare = this.mMin != null ? this.mMin.compareTo((Object)key) : -1;
        int maxKeyCompare = this.mMax != null ? this.mMax.compareTo((Object)key) : 1;
        boolean lowerBoundValid = minKeyCompare == 0 && this.mIncMin || minKeyCompare < 0;
        boolean upperBoundValid = maxKeyCompare == 0 && this.mIncMax || maxKeyCompare > 0;
        return upperBoundValid && lowerBoundValid;
    }
}

