/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.index.ChangeListener;
import org.sirix.index.Filter;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexFilterAxis;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.cas.CASFilter;
import org.sirix.index.cas.CASFilterRange;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public interface CASIndex<B, L extends ChangeListener, R extends NodeReadOnlyTrx & NodeCursor> {
    public B createBuilder(R var1, PageTrx<Long, Record, UnorderedKeyValuePage> var2, PathSummaryReader var3, IndexDef var4);

    public L createListener(PageTrx<Long, Record, UnorderedKeyValuePage> var1, PathSummaryReader var2, IndexDef var3);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageReadTrx, IndexDef indexDef, CASFilterRange filter) {
        AVLTreeReader reader;
        AVLTreeReader aVLTreeReader = reader = AVLTreeReader.getInstance(pageReadTrx, indexDef.getType(), indexDef.getID());
        Objects.requireNonNull(aVLTreeReader);
        AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        return new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)ImmutableSet.of((Object)filter))));
    }

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageReadTrx, IndexDef indexDef, CASFilter filter) {
        AVLTreeReader reader = AVLTreeReader.getInstance(pageReadTrx, indexDef.getType(), indexDef.getID());
        Set<Long> pcrsRequested = filter.getPCRs();
        Set<Long> pcrsAvailable = filter.getPCRCollector().getPCRsForPaths(indexDef.getPaths()).getPCRs();
        if (pcrsAvailable.size() <= 1 && pcrsRequested.size() == 1) {
            Atomic atomic = filter.getKey();
            long pcr = pcrsRequested.iterator().next();
            SearchMode mode = filter.getMode();
            CASValue value = new CASValue(atomic, atomic.type(), pcr);
            if (mode == SearchMode.EQUAL) {
                Optional node = reader.getAVLNode(value, mode);
                if (node.isPresent()) {
                    return Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)node.get().getValue()});
                }
                return Collections.emptyIterator();
            }
            Optional node = reader.getAVLNode(value, mode);
            if (node.isPresent()) {
                AVLTreeReader aVLTreeReader = reader;
                Objects.requireNonNull(aVLTreeReader);
                AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(node.get().getNodeKey());
                return Iterators.concat((Iterator)Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)node.get().getValue()}), new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)ImmutableSet.of((Object)filter)))));
            }
            return Collections.emptyIterator();
        }
        if (pcrsRequested.size() == 1) {
            Atomic atomic = filter.getKey();
            long pcr = pcrsRequested.iterator().next();
            SearchMode mode = filter.getMode();
            CASValue value = new CASValue(atomic, atomic.type(), pcr);
            if (mode == SearchMode.EQUAL) {
                Optional node = reader.getAVLNode(value, mode);
                if (node.isPresent()) {
                    AVLTreeReader aVLTreeReader = reader;
                    Objects.requireNonNull(aVLTreeReader);
                    AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(node.get().getNodeKey());
                    return Iterators.concat((Iterator)Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)node.get().getValue()}), new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)ImmutableSet.of((Object)filter)))));
                }
                return Collections.emptyIterator();
            }
            Optional node = reader.getAVLNode(value, SearchMode.EQUAL, (v1, v2) -> Long.valueOf(v1.getPathNodeKey()).compareTo(v2.getPathNodeKey()));
            if (node.isPresent()) {
                Optional firstFoundNode = reader.getAVLNode(node.get().getNodeKey(), value, mode);
                if (firstFoundNode.isPresent()) {
                    AVLTreeReader aVLTreeReader = reader;
                    Objects.requireNonNull(aVLTreeReader);
                    AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(firstFoundNode.get().getNodeKey());
                    return Iterators.concat((Iterator)Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)firstFoundNode.get().getValue()}), new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)ImmutableSet.of((Object)filter)))));
                }
                return Iterators.forArray((Object[])new NodeReferences[]{(NodeReferences)firstFoundNode.get().getValue()});
            }
            return Collections.emptyIterator();
        }
        AVLTreeReader aVLTreeReader = reader;
        Objects.requireNonNull(aVLTreeReader);
        AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        return new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)ImmutableSet.of((Object)filter))));
    }
}

