/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.index.ChangeListener;
import org.sirix.index.Filter;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexFilterAxis;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.name.NameFilter;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public interface NameIndex<B, L extends ChangeListener> {
    public B createBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> var1, IndexDef var2);

    public L createListener(PageTrx<Long, Record, UnorderedKeyValuePage> var1, IndexDef var2);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, NameFilter filter) {
        AVLTreeReader reader = AVLTreeReader.getInstance(pageRtx, indexDef.getType(), indexDef.getID());
        if (filter.getIncludes().size() == 1 && filter.getExcludes().isEmpty()) {
            Optional optionalNodeReferences = reader.get(filter.getIncludes().iterator().next(), SearchMode.EQUAL);
            return Iterators.forArray((Object[])new NodeReferences[]{optionalNodeReferences.orElse(new NodeReferences())});
        }
        AVLTreeReader aVLTreeReader = reader;
        Objects.requireNonNull(aVLTreeReader);
        AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        ImmutableSet setFilter = filter == null ? ImmutableSet.of() : ImmutableSet.of((Object)filter);
        return new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)setFilter)));
    }
}

