/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.node.interfaces.immutable.ImmutableNode;

public final class NameIndexListener {
    private final Set<QNm> mIncludes;
    private final Set<QNm> mExcludes;
    private final AVLTreeWriter<QNm, NodeReferences> mAVLTreeWriter;

    public NameIndexListener(Set<QNm> includes, Set<QNm> excludes, AVLTreeWriter<QNm, NodeReferences> avlTreeWriter) {
        this.mIncludes = includes;
        this.mExcludes = excludes;
        this.mAVLTreeWriter = avlTreeWriter;
    }

    public void listen(XmlIndexController.ChangeType type, @Nonnull ImmutableNode node, QNm name) {
        boolean excluded;
        boolean included = this.mIncludes.isEmpty() || this.mIncludes.contains(name);
        boolean bl = excluded = !this.mExcludes.isEmpty() && this.mExcludes.contains(name);
        if (!included || excluded) {
            return;
        }
        switch (type) {
            case INSERT: {
                Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(name, SearchMode.EQUAL);
                if (textReferences.isPresent()) {
                    this.setNodeReferences(node, textReferences.get(), name);
                    break;
                }
                this.setNodeReferences(node, new NodeReferences(), name);
                break;
            }
            case DELETE: {
                this.mAVLTreeWriter.remove(name, node.getNodeKey());
                break;
            }
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, QNm name) {
        this.mAVLTreeWriter.index(name, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

