/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.sirix.index.Filter;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PCRValue;

public final class PathFilter
implements Filter {
    private final boolean mGenericPath;
    private final Set<Path<QNm>> mPaths;
    private long mMaxKnownPCR;
    private Set<Long> mPCRFilter;
    private final PCRCollector mPCRCollector;

    public PathFilter(Set<Path<QNm>> paths, PCRCollector pcrCollector) {
        this.mPaths = Objects.requireNonNull(paths, "The paths must not be null.");
        this.mPCRCollector = Objects.requireNonNull(pcrCollector, "The path class record collector must not be null.");
        this.mGenericPath = this.mPaths.isEmpty();
        PCRValue pcrValue = this.mPCRCollector.getPCRsForPaths(this.mPaths);
        this.mMaxKnownPCR = pcrValue.getMaxPCR();
        this.mPCRFilter = pcrValue.getPCRs();
    }

    public Set<Long> getPCRs() {
        return Collections.unmodifiableSet(this.mPCRFilter);
    }

    public PCRCollector getPCRCollector() {
        return this.mPCRCollector;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(AVLNode<K, NodeReferences> node) {
        if (this.mGenericPath) {
            return true;
        }
        K key = node.getKey();
        long pcr = 0L;
        if (key instanceof Long) {
            pcr = (Long)key;
        } else if (key instanceof CASValue) {
            pcr = ((CASValue)key).getPathNodeKey();
        } else {
            throw new IllegalStateException();
        }
        if (pcr > this.mMaxKnownPCR) {
            PCRValue pcrValue = this.mPCRCollector.getPCRsForPaths(this.mPaths);
            this.mMaxKnownPCR = pcrValue.getMaxPCR();
            this.mPCRFilter = pcrValue.getPCRs();
        }
        return this.mPCRFilter.contains(pcr);
    }
}

