/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path.summary;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.Utils;
import org.sirix.access.trx.node.NodeFactory;
import org.sirix.access.trx.node.xml.InsertPos;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageTrx;
import org.sirix.api.ResourceManager;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.ChildAxis;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.LevelOrderAxis;
import org.sirix.axis.PostOrderAxis;
import org.sirix.axis.filter.FilterAxis;
import org.sirix.axis.filter.PathKindFilter;
import org.sirix.axis.filter.PathNameFilter;
import org.sirix.index.path.summary.AbstractForwardingPathSummaryReader;
import org.sirix.index.path.summary.PathNode;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.Kind;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.immutable.ImmutableNameNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.json.ArrayNode;
import org.sirix.node.json.ObjectRecordNode;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public final class PathSummaryWriter<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractForwardingPathSummaryReader {
    private final PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;
    private final PathSummaryReader mPathSummaryReader;
    private final NodeFactory mNodeFactory;
    private final R mNodeRtx;

    public PathSummaryWriter(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, ResourceManager<R, ? extends NodeTrx> resMgr, NodeFactory nodeFactory, R rtx) {
        this.mPageWriteTrx = (PageTrx)Preconditions.checkNotNull(pageWriteTrx);
        this.mPathSummaryReader = PathSummaryReader.getInstance(pageWriteTrx, resMgr);
        this.mNodeRtx = (NodeCursor)Preconditions.checkNotNull(rtx);
        this.mNodeFactory = (NodeFactory)Preconditions.checkNotNull((Object)nodeFactory);
    }

    public PathSummaryReader getPathSummary() {
        return this.mPathSummaryReader;
    }

    public long getPathNodeKey(QNm name, Kind pathKind) {
        Kind kind = this.mNodeRtx.getNode().getKind();
        int level = 0;
        if (kind == Kind.XDM_DOCUMENT || kind == Kind.JSON_DOCUMENT) {
            this.mPathSummaryReader.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        } else {
            this.movePathSummary();
            level = this.mPathSummaryReader.getLevel();
        }
        long nodeKey = this.mPathSummaryReader.getNodeKey();
        FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.mPathSummaryReader), new PathNameFilter(this.mPathSummaryReader, pathKind == Kind.NAMESPACE ? name.getPrefix() : Utils.buildName(name)), new PathKindFilter(this.mPathSummaryReader, pathKind));
        long retVal = nodeKey;
        if (axis.hasNext()) {
            axis.next();
            retVal = this.mPathSummaryReader.getNodeKey();
            PathNode pathNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(retVal, PageKind.PATHSUMMARYPAGE, 0);
            pathNode.incrementReferenceCount();
        } else {
            assert (nodeKey == this.mPathSummaryReader.getNodeKey());
            this.insertPathAsFirstChild(name, pathKind, level + 1);
            retVal = this.mPathSummaryReader.getNodeKey();
        }
        return retVal;
    }

    private void movePathSummary() {
        if (this.mNodeRtx.getNode() instanceof ImmutableNameNode) {
            this.mPathSummaryReader.moveTo(((ImmutableNameNode)this.mNodeRtx.getNode()).getPathNodeKey());
        } else if (this.mNodeRtx.getKind() == Kind.OBJECT_RECORD) {
            this.mPathSummaryReader.moveTo(((ObjectRecordNode)this.mNodeRtx.getNode()).getPathNodeKey());
        } else if (this.mNodeRtx.getKind() == Kind.ARRAY) {
            this.mPathSummaryReader.moveTo(((ArrayNode)this.mNodeRtx.getNode()).getPathNodeKey());
        } else {
            throw new IllegalStateException();
        }
    }

    public PathSummaryWriter<R> insertPathAsFirstChild(QNm name, Kind pathKind, int level) {
        long parentKey = this.mPathSummaryReader.getNodeKey();
        long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
        long rightSibKey = this.mPathSummaryReader.getFirstChildKey();
        PathNode node = this.mNodeFactory.createPathNode(parentKey, leftSibKey, rightSibKey, name, pathKind, level);
        this.mPathSummaryReader.putMapping(node.getNodeKey(), node);
        this.mPathSummaryReader.moveTo(node.getNodeKey());
        this.adaptForInsert(node, InsertPos.ASFIRSTCHILD, PageKind.PATHSUMMARYPAGE);
        this.mPathSummaryReader.moveTo(node.getNodeKey());
        this.mPathSummaryReader.putQNameMapping(node, name);
        return this;
    }

    private void adaptForInsert(Node newNode, InsertPos insertPos, PageKind pageKind) {
        assert (newNode != null);
        assert (insertPos != null);
        assert (pageKind != null);
        if (newNode instanceof StructNode) {
            StructNode strucNode = (StructNode)newNode;
            StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(newNode.getParentKey(), pageKind, 0);
            parent.incrementChildCount();
            if (insertPos == InsertPos.ASFIRSTCHILD) {
                parent.setFirstChildKey(newNode.getNodeKey());
            }
            if (strucNode.hasRightSibling()) {
                StructNode rightSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(strucNode.getRightSiblingKey(), pageKind, 0);
                rightSiblingNode.setLeftSiblingKey(newNode.getNodeKey());
            }
            if (strucNode.hasLeftSibling()) {
                StructNode leftSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(strucNode.getLeftSiblingKey(), pageKind, 0);
                leftSiblingNode.setRightSiblingKey(newNode.getNodeKey());
            }
        }
    }

    public void adaptPathForChangedNode(ImmutableNameNode node, QNm name, int uriKey, int prefixKey, int localNameKey, OPType type) {
        this.movePathSummary();
        long oldPathNodeKey = this.mPathSummaryReader.getNodeKey();
        if (type == OPType.SETNAME && this.mPathSummaryReader.getReferences() == 1) {
            this.moveSummaryGetLevel(node);
            FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.mPathSummaryReader), new PathNameFilter(this.mPathSummaryReader, Utils.buildName(name)), new PathKindFilter(this.mPathSummaryReader, node.getKind()));
            if (axis.hasNext()) {
                axis.next();
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.mPathSummaryReader.moveTo(nodeKey);
                this.processFoundPathNode(oldPathNodeKey, this.mPathSummaryReader.getNodeKey(), node.getNodeKey(), uriKey, prefixKey, localNameKey, RemoveSubtreePath.YES, type);
            } else if (this.mPathSummaryReader.getKind() != Kind.XDM_DOCUMENT) {
                this.mPathSummaryReader.moveTo(oldPathNodeKey);
                PathNode pathNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
                pathNode.setPrefixKey(prefixKey);
                pathNode.setLocalNameKey(localNameKey);
                pathNode.setURIKey(uriKey);
            }
        } else {
            int level = this.moveSummaryGetLevel(node);
            FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.mPathSummaryReader), new PathNameFilter(this.mPathSummaryReader, Utils.buildName(name)), new PathKindFilter(this.mPathSummaryReader, node.getKind()));
            if (axis.hasNext()) {
                axis.next();
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.mPathSummaryReader.moveTo(nodeKey);
                this.processFoundPathNode(oldPathNodeKey, this.mPathSummaryReader.getNodeKey(), node.getNodeKey(), uriKey, prefixKey, localNameKey, RemoveSubtreePath.NO, type);
            } else {
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.mPathSummaryReader.moveTo(nodeKey);
                boolean firstRun = true;
                DescendantAxis descendants = new DescendantAxis((NodeCursor)this.mNodeRtx, IncludeSelf.YES);
                while (descendants.hasNext()) {
                    descendants.next();
                    if (this.mNodeRtx.getKind() != Kind.ELEMENT && this.mNodeRtx.getKind() != Kind.OBJECT_RECORD) continue;
                    if (firstRun) {
                        this.insertPathAsFirstChild(name, this.mNodeRtx.getKind(), ++level);
                        nodeKey = this.mPathSummaryReader.getNodeKey();
                    } else {
                        this.insertPathAsFirstChild(((NodeReadOnlyTrx)this.mNodeRtx).getName(), this.mNodeRtx.getKind(), ++level);
                    }
                    this.resetPathNodeKey(((NodeReadOnlyTrx)this.mNodeRtx).getNodeKey());
                    if (this.mNodeRtx instanceof XmlNodeReadOnlyTrx) {
                        int i;
                        XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mNodeRtx;
                        int nsps = rtx.getNamespaceCount();
                        for (i = 0; i < nsps; ++i) {
                            rtx.moveToNamespace(i);
                            this.insertPathAsFirstChild(rtx.getName(), Kind.NAMESPACE, level + 1);
                            this.resetPathNodeKey(rtx.getNodeKey());
                            rtx.moveToParent();
                            this.mPathSummaryReader.moveToParent();
                        }
                        int atts = rtx.getAttributeCount();
                        for (i = 0; i < atts; ++i) {
                            rtx.moveToAttribute(i);
                            this.insertPathAsFirstChild(rtx.getName(), Kind.ATTRIBUTE, level + 1);
                            this.resetPathNodeKey(rtx.getNodeKey());
                            rtx.moveToParent();
                            this.mPathSummaryReader.moveToParent();
                        }
                    }
                    if (firstRun) {
                        firstRun = false;
                        continue;
                    }
                    this.mPathSummaryReader.moveToParent();
                    --level;
                }
                this.mPathSummaryReader.moveTo(nodeKey);
            }
        }
    }

    private long decrementReferenceCountOrRemove(ImmutableNameNode node) {
        long nodeKey = this.mPathSummaryReader.getNodeKey();
        ((NodeReadOnlyTrx)this.mNodeRtx).moveTo(node.getNodeKey());
        PostOrderAxis descendants = new PostOrderAxis((NodeCursor)this.mNodeRtx, IncludeSelf.YES);
        while (descendants.hasNext()) {
            descendants.next();
            if (this.mNodeRtx.getKind() == Kind.ELEMENT) {
                int i;
                XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mNodeRtx;
                ImmutableElement element = (ImmutableElement)rtx.getNode();
                int nsps = element.getNamespaceCount();
                for (i = 0; i < nsps; ++i) {
                    rtx.moveToNamespace(i);
                    this.deleteOrDecrement();
                    rtx.moveToParent();
                }
                int atts = element.getAttributeCount();
                for (i = 0; i < atts; ++i) {
                    rtx.moveToAttribute(i);
                    this.deleteOrDecrement();
                    rtx.moveToParent();
                }
            }
            this.deleteOrDecrement();
        }
        return nodeKey;
    }

    private void processFoundPathNode(@Nonnegative long oldPathNodeKey, @Nonnegative long newPathNodeKey, @Nonnegative long oldNodeKey, int uriKey, int prefixKey, int localNameKey, RemoveSubtreePath remove, OPType type) {
        ((NodeReadOnlyTrx)this.mNodeRtx).moveTo(oldNodeKey);
        PathNode currNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
        currNode.setReferenceCount(currNode.getReferences() + 1);
        currNode.setLocalNameKey(localNameKey);
        currNode.setPrefixKey(prefixKey);
        currNode.setURIKey(uriKey);
        long pathNodeKey = currNode.getNodeKey();
        this.processElementNonStructuralNodes(pathNodeKey, 0);
        boolean movedNodeCursorToFirstChild = this.mNodeRtx.moveToFirstChild().hasMoved();
        boolean movedPathSummaryToFirstChild = this.mPathSummaryReader.moveToFirstChild().hasMoved();
        if (movedNodeCursorToFirstChild && movedPathSummaryToFirstChild) {
            long pathRootNodeKey = this.mPathSummaryReader.getNodeKey();
            LevelOrderAxis levelOrderAxis = new LevelOrderAxis.Builder((NodeCursor)this.mNodeRtx).includeSelf().build();
            while (levelOrderAxis.hasNext()) {
                levelOrderAxis.next();
                if (!(this.mNodeRtx.getNode() instanceof ImmutableNameNode)) continue;
                this.adaptPathSummary(levelOrderAxis.getCurrentLevel(), pathRootNodeKey);
                this.processElementNonStructuralNodes(pathRootNodeKey, levelOrderAxis.getCurrentLevel());
            }
        } else if (movedNodeCursorToFirstChild) {
            LevelOrderAxis levelOrderAxis = new LevelOrderAxis.Builder((NodeCursor)this.mNodeRtx).includeSelf().build();
            while (levelOrderAxis.hasNext()) {
                levelOrderAxis.next();
                if (!(this.mNodeRtx.getNode() instanceof ImmutableNameNode)) continue;
                this.adaptForNewPathNode();
                this.processElementNonStructuralNodes(this.mPathSummaryReader.getNodeKey(), levelOrderAxis.getCurrentLevel());
            }
        } else if (movedPathSummaryToFirstChild) {
            this.mPathSummaryReader.moveToParent();
        }
        this.mPathSummaryReader.moveTo(pathNodeKey);
    }

    private void processElementNonStructuralNodes(long pathRootNodeKey, int level) {
        if (this.mNodeRtx.getNode().getKind() == Kind.ELEMENT) {
            int i;
            XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mNodeRtx;
            ImmutableElement element = (ImmutableElement)rtx.getNode();
            int nspCount = element.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                rtx.moveToNamespace(i);
                this.adaptPathSummary(level, pathRootNodeKey);
                rtx.moveToParent();
            }
            int attCount = element.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                this.adaptPathSummary(level, pathRootNodeKey);
                rtx.moveToParent();
            }
        }
    }

    private void adaptPathSummary(int level, long newPathNodeKey) {
        FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new LevelOrderAxis.Builder(this.mPathSummaryReader).filterLevel(level).includeSelf().build(), new PathNameFilter(this.mPathSummaryReader, Utils.buildName(((NodeReadOnlyTrx)this.mNodeRtx).getName())), new PathKindFilter(this.mPathSummaryReader, this.mNodeRtx.getKind()));
        if (axis.hasNext()) {
            axis.next();
            this.adaptForFoundPathNode();
        } else {
            this.adaptForNewPathNode();
        }
        this.mPathSummaryReader.moveTo(newPathNodeKey);
    }

    private void adaptForNewPathNode() {
        this.moveToPathNodeOfParentNode();
        this.insertPathAsFirstChild(((NodeReadOnlyTrx)this.mNodeRtx).getName(), this.mNodeRtx.getKind(), this.mPathSummaryReader.getLevel() + 1);
        this.setReferenceCountToOne();
        this.setNewPathNodeKey();
    }

    private void moveToPathNodeOfParentNode() {
        long pathNodeKey;
        long nodeKey = ((NodeReadOnlyTrx)this.mNodeRtx).getNodeKey();
        if (this.mNodeRtx instanceof XmlNodeReadOnlyTrx) {
            pathNodeKey = ((XmlNodeReadOnlyTrx)this.mNodeRtx.moveToParent().trx()).getPathNodeKey();
        } else if (this.mNodeRtx instanceof JsonNodeReadOnlyTrx) {
            pathNodeKey = ((JsonNodeReadOnlyTrx)this.mNodeRtx.moveToParent().trx()).getPathNodeKey();
        } else {
            throw new IllegalStateException("Node transaction kind not known.");
        }
        this.mPathSummaryReader.moveTo(pathNodeKey);
        ((NodeReadOnlyTrx)this.mNodeRtx).moveTo(nodeKey);
    }

    private void adaptForFoundPathNode() {
        this.increaseReferenceCount();
        this.resetPathNodeKey(((NodeReadOnlyTrx)this.mNodeRtx).getNodeKey());
    }

    private void setNewPathNodeKey() {
        NameNode node = (NameNode)this.mPageWriteTrx.prepareEntryForModification(((NodeReadOnlyTrx)this.mNodeRtx).getNodeKey(), PageKind.RECORDPAGE, -1);
        node.setPathNodeKey(this.mPathSummaryReader.getNodeKey());
    }

    private void setReferenceCountToOne() {
        PathNode currNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
        currNode.setReferenceCount(1);
    }

    private void increaseReferenceCount() {
        PathNode currNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
        currNode.setReferenceCount(currNode.getReferences() + 1);
    }

    private int moveSummaryGetLevel(ImmutableNode node) {
        assert (node != null);
        this.mNodeRtx.moveToParent();
        int level = 0;
        if (this.mNodeRtx.getKind() == Kind.XDM_DOCUMENT) {
            this.mPathSummaryReader.moveToDocumentRoot();
        } else {
            this.movePathSummary();
            level = this.mPathSummaryReader.getLevel();
        }
        ((NodeReadOnlyTrx)this.mNodeRtx).moveTo(node.getNodeKey());
        return level;
    }

    private void resetPathNodeKey(@Nonnegative long nodeKey) {
        NameNode currNode = (NameNode)this.mPageWriteTrx.prepareEntryForModification(nodeKey, PageKind.RECORDPAGE, -1);
        currNode.setPathNodeKey(this.mPathSummaryReader.getNodeKey());
    }

    private void removePathSummaryNode(RemoveSubtreePath remove) {
        if (remove == RemoveSubtreePath.YES) {
            DescendantAxis axis = new DescendantAxis(this.mPathSummaryReader);
            while (axis.hasNext()) {
                axis.next();
                this.mPathSummaryReader.removeMapping(this.mPathSummaryReader.getNodeKey());
                this.mPathSummaryReader.removeQNameMapping(this.mPathSummaryReader.getPathNode(), this.mPathSummaryReader.getName());
                this.mPageWriteTrx.removeEntry(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
            }
        }
        if (this.mPathSummaryReader.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getLeftSiblingKey(), PageKind.PATHSUMMARYPAGE, 0);
            leftSibling.setRightSiblingKey(this.mPathSummaryReader.getRightSiblingKey());
        }
        if (this.mPathSummaryReader.hasRightSibling()) {
            StructNode rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getRightSiblingKey(), PageKind.PATHSUMMARYPAGE, 0);
            rightSibling.setLeftSiblingKey(this.mPathSummaryReader.getLeftSiblingKey());
        }
        StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getParentKey(), PageKind.PATHSUMMARYPAGE, 0);
        if (!this.mPathSummaryReader.hasLeftSibling()) {
            parent.setFirstChildKey(this.mPathSummaryReader.getRightSiblingKey());
        }
        parent.decrementChildCount();
        this.mPathSummaryReader.removeMapping(this.mPathSummaryReader.getNodeKey());
        this.mPathSummaryReader.removeQNameMapping(this.mPathSummaryReader.getPathNode(), this.mPathSummaryReader.getName());
        this.mPageWriteTrx.removeEntry(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
    }

    private void deleteOrDecrement() {
        if (this.mNodeRtx.getNode() instanceof ImmutableNameNode) {
            this.movePathSummary();
            if (this.mPathSummaryReader.getReferences() == 1) {
                this.removePathSummaryNode(RemoveSubtreePath.NO);
            } else {
                PathNode pathNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
                pathNode.decrementReferenceCount();
            }
        }
    }

    public void remove(NameNode node, Kind nodeKind, NamePage page) {
        if (this.mPathSummaryReader.moveTo(node.getPathNodeKey()).hasMoved()) {
            if (this.mPathSummaryReader.getReferences() == 1) {
                this.removePathSummaryNode(RemoveSubtreePath.YES);
            } else {
                assert (page.getCount(node.getLocalNameKey(), nodeKind) != 0);
                if (this.mPathSummaryReader.getReferences() > 1) {
                    PathNode pathNode = (PathNode)this.mPageWriteTrx.prepareEntryForModification(this.mPathSummaryReader.getNodeKey(), PageKind.PATHSUMMARYPAGE, 0);
                    pathNode.decrementReferenceCount();
                }
            }
        }
    }

    @Override
    protected PathSummaryReader delegate() {
        return this.mPathSummaryReader;
    }

    private static enum RemoveSubtreePath {
        YES,
        NO;

    }

    public static enum OPType {
        MOVED_ON_SAME_LEVEL,
        MOVED,
        SETNAME;

    }
}

