/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.bytepipe;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sirix.io.bytepipe.ByteHandler;
import org.sirix.io.bytepipe.DeflateCompressor;
import org.sirix.io.bytepipe.Encryptor;
import org.sirix.io.bytepipe.SnappyCompressor;

public enum ByteHandlerKind {
    DEFLATE_COMPRESSOR(DeflateCompressor.class){

        @Override
        public ByteHandler deserialize(JsonReader reader) {
            return ByteHandlerKind.callDefaultConstructor(reader, DeflateCompressor.class.getName());
        }

        @Override
        public void serialize(ByteHandler byteHandler, JsonWriter writer) throws IOException {
            ByteHandlerKind.serializeDefaultConstructor(byteHandler, writer);
        }
    }
    ,
    SNAPPY_COMPRESSOR(SnappyCompressor.class){

        @Override
        public ByteHandler deserialize(JsonReader reader) {
            return ByteHandlerKind.callDefaultConstructor(reader, SnappyCompressor.class.getName());
        }

        @Override
        public void serialize(ByteHandler byteHandler, JsonWriter writer) throws IOException {
            ByteHandlerKind.serializeDefaultConstructor(byteHandler, writer);
        }
    }
    ,
    ENCRYPTOR(Encryptor.class){

        @Override
        public ByteHandler deserialize(JsonReader reader) {
            try {
                Class<Encryptor> handlerClazz = Encryptor.class;
                Constructor handlerCons = handlerClazz.getConstructor(Path.class);
                Path path = Paths.get(reader.nextString(), new String[0]);
                return (ByteHandler)handlerCons.newInstance(path);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void serialize(ByteHandler byteHandler, JsonWriter writer) {
            try {
                writer.beginObject();
                writer.name(byteHandler.getClass().getName());
                writer.value(((Encryptor)byteHandler).getResourcePath().toString());
                writer.endObject();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    private static final Map<Class<? extends ByteHandler>, ByteHandlerKind> INSTANCEFORCLASS;
    private final Class<? extends ByteHandler> mClass;

    public abstract ByteHandler deserialize(JsonReader var1) throws IOException;

    public abstract void serialize(ByteHandler var1, JsonWriter var2) throws IOException;

    private ByteHandlerKind(Class<? extends ByteHandler> clazz) {
        this.mClass = clazz;
    }

    private static void serializeDefaultConstructor(ByteHandler byteHandler, JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name(byteHandler.getClass().getName());
        writer.nullValue();
        writer.endObject();
    }

    private static ByteHandler callDefaultConstructor(JsonReader reader, String className) {
        try {
            reader.nextNull();
            Class<?> handlerClazz = Class.forName(className);
            Constructor<?> handlerCons = handlerClazz.getConstructors()[0];
            return (ByteHandler)handlerCons.newInstance(new Object[0]);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static ByteHandlerKind getKind(Class<? extends ByteHandler> clazz) {
        ByteHandlerKind byteHandler = INSTANCEFORCLASS.get(clazz);
        if (byteHandler == null) {
            throw new IllegalStateException();
        }
        return byteHandler;
    }

    static {
        INSTANCEFORCLASS = new HashMap<Class<? extends ByteHandler>, ByteHandlerKind>();
        for (ByteHandlerKind byteHandler : ByteHandlerKind.values()) {
            INSTANCEFORCLASS.put(byteHandler.mClass, byteHandler);
        }
    }
}

