/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.file;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Reader;
import org.sirix.io.bytepipe.ByteHandler;
import org.sirix.page.PagePersister;
import org.sirix.page.PageReference;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.SerializationType;
import org.sirix.page.UberPage;
import org.sirix.page.interfaces.Page;

public final class FileReader
implements Reader {
    static final int FIRST_BEACON = 12;
    static final int OTHER_BEACON = 4;
    final ByteHandler mByteHandler;
    final HashFunction mHashFunction = Hashing.sha256();
    private final RandomAccessFile mDataFile;
    private final RandomAccessFile mRevisionsOffsetFile;
    private final SerializationType mType;
    private final PagePersister mPagePersiter;

    public FileReader(RandomAccessFile dataFile, RandomAccessFile revisionsOffsetFile, ByteHandler handler, SerializationType type, PagePersister pagePersistenter) {
        this.mDataFile = (RandomAccessFile)Preconditions.checkNotNull((Object)dataFile);
        this.mRevisionsOffsetFile = type == SerializationType.DATA ? (RandomAccessFile)Preconditions.checkNotNull((Object)revisionsOffsetFile) : null;
        this.mByteHandler = (ByteHandler)Preconditions.checkNotNull((Object)handler);
        this.mType = (SerializationType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mPagePersiter = (PagePersister)Preconditions.checkNotNull((Object)pagePersistenter);
    }

    @Override
    public Page read(@Nonnull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            switch (this.mType) {
                case DATA: {
                    this.mDataFile.seek(reference.getKey());
                    break;
                }
                case TRANSACTION_INTENT_LOG: {
                    this.mDataFile.seek(reference.getPersistentLogKey());
                    break;
                }
            }
            int dataLength = this.mDataFile.readInt();
            reference.setLength(dataLength + 4);
            byte[] page = new byte[dataLength];
            this.mDataFile.read(page);
            DataInputStream input = new DataInputStream(this.mByteHandler.deserialize(new ByteArrayInputStream(page)));
            return this.mPagePersiter.deserializePage(input, pageReadTrx, this.mType);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public PageReference readUberPageReference() {
        PageReference uberPageReference = new PageReference();
        try {
            this.mDataFile.seek(0L);
            uberPageReference.setKey(this.mDataFile.readLong());
            UberPage page = (UberPage)this.read(uberPageReference, null);
            uberPageReference.setPage(page);
            return uberPageReference;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
        try {
            this.mRevisionsOffsetFile.seek(revision * 8);
            this.mDataFile.seek(this.mRevisionsOffsetFile.readLong());
            int dataLength = this.mDataFile.readInt();
            byte[] page = new byte[dataLength];
            this.mDataFile.read(page);
            DataInputStream input = new DataInputStream(this.mByteHandler.deserialize(new ByteArrayInputStream(page)));
            return (RevisionRootPage)this.mPagePersiter.deserializePage(input, pageReadTrx, this.mType);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() throws SirixIOException {
        try {
            if (this.mRevisionsOffsetFile != null) {
                this.mRevisionsOffsetFile.close();
            }
            this.mDataFile.close();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }
}

