/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sirix.access.ResourceConfiguration;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Reader;
import org.sirix.io.Storage;
import org.sirix.io.Writer;
import org.sirix.io.bytepipe.ByteHandlePipeline;
import org.sirix.io.bytepipe.ByteHandler;
import org.sirix.io.file.FileReader;
import org.sirix.io.file.FileWriter;
import org.sirix.page.PagePersister;
import org.sirix.page.SerializationType;

public final class FileStorage
implements Storage {
    private static final String FILENAME = "sirix.data";
    private static final String REVISIONS_FILENAME = "sirix.revisions";
    private final Path mFile;
    private final ByteHandlePipeline mByteHandler;

    public FileStorage(ResourceConfiguration resourceConfig) {
        assert (resourceConfig != null) : "resourceConfig must not be null!";
        this.mFile = resourceConfig.resourcePath;
        this.mByteHandler = resourceConfig.byteHandlePipeline;
    }

    @Override
    public Reader createReader() throws SirixIOException {
        try {
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            return new FileReader(new RandomAccessFile(dataFilePath.toFile(), "r"), new RandomAccessFile(revisionsOffsetFilePath.toFile(), "r"), new ByteHandlePipeline(this.mByteHandler), SerializationType.DATA, new PagePersister());
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private Path createDirectoriesAndFile() throws IOException {
        Path concreteStorage = this.getDataFilePath();
        if (!Files.exists(concreteStorage, new LinkOption[0])) {
            Files.createDirectories(concreteStorage.getParent(), new FileAttribute[0]);
            Files.createFile(concreteStorage, new FileAttribute[0]);
        }
        return concreteStorage;
    }

    @Override
    public Writer createWriter() throws SirixIOException {
        try {
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            return new FileWriter(new RandomAccessFile(dataFilePath.toFile(), "rw"), new RandomAccessFile(revisionsOffsetFilePath.toFile(), "rw"), new ByteHandlePipeline(this.mByteHandler), SerializationType.DATA, new PagePersister());
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() {
    }

    private Path getDataFilePath() {
        return this.mFile.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(FILENAME);
    }

    private Path getRevisionFilePath() {
        return this.mFile.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(REVISIONS_FILENAME);
    }

    @Override
    public boolean exists() throws SirixIOException {
        Path storage = this.getDataFilePath();
        try {
            return Files.exists(storage, new LinkOption[0]) && Files.size(storage) > 0L;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public ByteHandler getByteHandler() {
        return this.mByteHandler;
    }
}

