/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.ram;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.exception.SirixIOException;
import org.sirix.io.Reader;
import org.sirix.io.Storage;
import org.sirix.io.Writer;
import org.sirix.io.bytepipe.ByteHandlePipeline;
import org.sirix.page.PageReference;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.UberPage;
import org.sirix.page.interfaces.Page;

public final class RAMStorage
implements Storage {
    private final ConcurrentMap<String, ConcurrentMap<Long, Page>> mDataStorage;
    private final ConcurrentMap<String, ConcurrentMap<Integer, RevisionRootPage>> mRevisionRootsStorage;
    private ConcurrentMap<Long, Page> mResourceFileStorage;
    private ConcurrentMap<Integer, RevisionRootPage> mResourceRevisionRootsStorage;
    private final ConcurrentMap<Integer, Long> mUberPageKey;
    private final ByteHandlePipeline mHandler;
    private final RAMAccess mAccess;
    private boolean mExists;
    private long mPageKey;
    private final ResourceConfiguration mResourceConfiguration;

    public RAMStorage(ResourceConfiguration resourceConfig) {
        this.mResourceConfiguration = resourceConfig;
        this.mDataStorage = new ConcurrentHashMap<String, ConcurrentMap<Long, Page>>();
        this.mRevisionRootsStorage = new ConcurrentHashMap<String, ConcurrentMap<Integer, RevisionRootPage>>();
        this.mHandler = resourceConfig.byteHandlePipeline;
        this.mAccess = new RAMAccess();
        this.mUberPageKey = new ConcurrentHashMap<Integer, Long>();
        this.mUberPageKey.put(-1, 0L);
    }

    @Override
    public Writer createWriter() {
        this.instantiate();
        return this.mAccess;
    }

    private void instantiate() {
        String resource = this.mResourceConfiguration.getResource().getFileName().toString();
        this.mExists = this.mDataStorage.containsKey(resource);
        this.mDataStorage.putIfAbsent(resource, new ConcurrentHashMap());
        this.mResourceFileStorage = (ConcurrentMap)this.mDataStorage.get(resource);
        this.mRevisionRootsStorage.putIfAbsent(resource, new ConcurrentHashMap());
        this.mResourceRevisionRootsStorage = (ConcurrentMap)this.mRevisionRootsStorage.get(resource);
    }

    @Override
    public Reader createReader() {
        this.instantiate();
        return this.mAccess;
    }

    @Override
    public void close() {
    }

    @Override
    public ByteHandlePipeline getByteHandler() {
        return this.mHandler;
    }

    @Override
    public boolean exists() throws SirixIOException {
        return this.mExists;
    }

    public class RAMAccess
    implements Writer {
        @Override
        public Writer truncate() {
            RAMStorage.this.mUberPageKey.clear();
            RAMStorage.this.mResourceFileStorage.clear();
            return this;
        }

        @Override
        public Page read(PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
            return (Page)RAMStorage.this.mResourceFileStorage.get(reference.getKey());
        }

        @Override
        public PageReference readUberPageReference() {
            Page page = (Page)RAMStorage.this.mResourceFileStorage.get(RAMStorage.this.mUberPageKey.get(-1));
            PageReference uberPageReference = new PageReference();
            uberPageReference.setKey(-1L);
            uberPageReference.setPage(page);
            return uberPageReference;
        }

        @Override
        public Writer write(PageReference pageReference) throws SirixIOException {
            Page page = pageReference.getPage();
            pageReference.setKey(RAMStorage.this.mPageKey);
            RAMStorage.this.mResourceFileStorage.put(RAMStorage.this.mPageKey++, page);
            return this;
        }

        @Override
        public Writer writeUberPageReference(PageReference pageReference) throws SirixIOException {
            Page page = pageReference.getPage();
            pageReference.setKey(RAMStorage.this.mPageKey);
            RAMStorage.this.mResourceFileStorage.put(RAMStorage.this.mPageKey, page);
            RAMStorage.this.mUberPageKey.put(-1, RAMStorage.this.mPageKey++);
            return this;
        }

        @Override
        public void close() throws SirixIOException {
        }

        @Override
        public Writer truncateTo(int revision) {
            PageReference uberPageReference = this.readUberPageReference();
            UberPage uberPage = (UberPage)uberPageReference.getPage();
            while (uberPage.getRevisionNumber() != revision) {
                RAMStorage.this.mResourceFileStorage.remove(uberPageReference.getKey());
                Long previousUberPageKey = uberPage.getPreviousUberPageKey();
                uberPage = (UberPage)this.read(new PageReference().setKey(previousUberPageKey), null);
                uberPageReference = new PageReference();
                uberPageReference.setKey(previousUberPageKey);
                if (uberPage.getRevisionNumber() != revision) continue;
                RAMStorage.this.mResourceFileStorage.put(previousUberPageKey, uberPage);
                RAMStorage.this.mUberPageKey.put(-1, previousUberPageKey);
                break;
            }
            return this;
        }

        @Override
        public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
            return (RevisionRootPage)RAMStorage.this.mResourceRevisionRootsStorage.get(revision);
        }
    }
}

