/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.settings.Constants;
import org.sirix.utils.Compression;

public class ValNodeDelegate
extends AbstractForwardingNode
implements ValueNode {
    private NodeDelegate mDelegate;
    private byte[] mVal;
    private boolean mCompressed;

    public ValNodeDelegate(NodeDelegate nodeDel, byte[] val, boolean compressed) {
        assert (nodeDel != null) : "nodeDel must not be null!";
        assert (val != null) : "val must not be null!";
        this.mDelegate = nodeDel;
        this.mVal = val;
        this.mCompressed = compressed;
    }

    @Override
    public byte[] getRawValue() {
        return this.mCompressed ? Compression.decompress(this.mVal) : this.mVal;
    }

    @Override
    public String getValue() {
        return new String(this.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    public byte[] getCompressed() {
        return this.mVal;
    }

    @Override
    public void setValue(byte[] value) {
        this.mCompressed = new String(value).length() > 10;
        this.mVal = this.mCompressed ? Compression.compress(value, -1) : value;
    }

    public boolean isCompressed() {
        return this.mCompressed;
    }

    public void setCompressed(boolean compressed) {
        this.mCompressed = compressed;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDelegate, this.mVal});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ValNodeDelegate)) {
            return false;
        }
        ValNodeDelegate other = (ValNodeDelegate)obj;
        return Objects.equal((Object)this.mDelegate, (Object)other.mDelegate) && Arrays.equals(this.mVal, other.mVal);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)new String(this.mVal)).toString();
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        return this.mDelegate.isSameItem(other);
    }

    @Override
    public Kind getKind() {
        return Kind.UNKNOWN;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mDelegate;
    }
}

