/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.json;

import com.google.common.base.Preconditions;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.immutable.json.ImmutableBooleanNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;

public final class BooleanNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode {
    private final StructNodeDelegate mStructNodeDel;
    private boolean mBoolValue;

    public BooleanNode(boolean boolValue, StructNodeDelegate structDel) {
        this.mBoolValue = boolValue;
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structDel);
    }

    public void setValue(boolean value) {
        this.mBoolValue = value;
    }

    public boolean getValue() {
        return this.mBoolValue;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableBooleanNode.of(this));
    }

    @Override
    public Kind getKind() {
        return Kind.BOOLEAN_VALUE;
    }

    @Override
    public StructNodeDelegate getStructNodeDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }
}

